/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau;

import com.dbeaver.model.tableau.TBObject;
import com.dbeaver.model.tableau.TBSite;
import com.dbeaver.model.tableau.rest.api.ProjectType;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.meta.Property;

public class TBProject
implements TBObject {
    private static final Log log = Log.getLog(TBProject.class);
    private final TBSite site;
    private final TBProject parentProject;
    private final ProjectType project;

    public TBProject(TBSite site, TBProject parentProject, ProjectType project) {
        this.site = site;
        this.parentProject = parentProject;
        this.project = project;
    }

    public TBProject getParentProject() {
        return this.parentProject;
    }

    public List<TBProject> getSubProjects() {
        ArrayList<TBProject> children = new ArrayList<TBProject>();
        for (TBProject p : this.site.getProjects()) {
            if (p.getParentProject() != this) continue;
            children.add(p);
        }
        return children;
    }

    public boolean hasSubProjects() {
        for (TBProject p : this.site.getProjects()) {
            if (p.getParentProject() != this) continue;
            return true;
        }
        return false;
    }

    @Override
    @Property(order=1)
    public String getId() {
        return this.project.getId();
    }

    @Property(order=2, viewable=true)
    @NotNull
    public String getName() {
        return this.project.getName();
    }

    @Property(order=30)
    @Nullable
    public String getDescription() {
        return this.project.getDescription();
    }

    @Property(order=12, viewable=true)
    @Nullable
    public String getCreatedAt() {
        return String.valueOf(this.project.getCreatedAt());
    }

    @Property(order=13, viewable=true)
    @Nullable
    public String getUpdatedAt() {
        return String.valueOf(this.project.getUpdatedAt());
    }

    public ProjectType getProjectType() {
        return this.project;
    }
}

