/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau;

import com.dbeaver.model.tableau.TBDataSource;
import com.dbeaver.model.tableau.TBObject;
import com.dbeaver.model.tableau.rest.api.RevisionType;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.meta.Property;

public class TBDataSourceRevision
implements TBObject {
    private static final Log log = Log.getLog(TBDataSourceRevision.class);
    private final TBDataSource dataSource;
    private RevisionType revisionType;

    public TBDataSourceRevision(TBDataSource dataSource, RevisionType revisionType) {
        this.dataSource = dataSource;
        this.revisionType = revisionType;
    }

    public TBDataSource getDataSource() {
        return this.dataSource;
    }

    public RevisionType getRevisionType() {
        return this.revisionType;
    }

    @Override
    @Property(order=1)
    public String getId() {
        return this.revisionType.getRevisionNumber().toString();
    }

    @NotNull
    public String getName() {
        return this.getId();
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Property(order=9)
    @Nullable
    public String getPublisher() {
        return this.revisionType.getPublisher() == null ? null : this.revisionType.getPublisher().getName();
    }

    @Property(order=10)
    @Nullable
    public String getPublishedAt() {
        return String.valueOf(this.revisionType.getPublishedAt());
    }

    @Property(order=11)
    @Nullable
    public Long getSize() {
        return this.revisionType.getSizeInBytes();
    }
}

