/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.dpi.adapters;

import com.dbeaver.dpi.DPIClientObject;
import com.dbeaver.dpi.DPIContext;
import com.dbeaver.dpi.DPIController;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.rest.RestProxy;

public class DPIClientProxy
implements DPIClientObject,
InvocationHandler {
    private static final Log log = Log.getLog(DPIClientProxy.class);
    public static final Object SELF_REFERENCE = new Object();
    public static final Object NULL_VALUE = new Object();
    private final DPIContext context;
    private final String objectId;
    private final String objectType;
    private final String objectToString;
    private final Integer objectHashCode;
    private final transient Object objectInstance;
    private Map<String, Object> propertyValues;

    public DPIClientProxy(@NotNull DPIContext context, @NotNull Class<?>[] allInterfaces, @NotNull String objectId, @Nullable String objectType, @Nullable String objectToString, @Nullable Integer objectHashCode, @Nullable Map<String, Object> propertyValues) {
        this.context = context;
        this.objectId = objectId;
        this.objectType = objectType;
        this.objectToString = objectToString;
        this.objectHashCode = objectHashCode;
        this.propertyValues = propertyValues;
        this.objectInstance = Proxy.newProxyInstance(context.getClassLoader(), allInterfaces, (InvocationHandler)this);
    }

    @Override
    public String dpiObjectId() {
        return this.objectId;
    }

    @Override
    public String dpiObjectType() {
        return this.objectType;
    }

    @Override
    public ClassLoader dpiClassLoader() {
        return this.context.getClassLoader();
    }

    @Override
    public Object dpiPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String propertyName) throws DBException {
        Object value;
        Object object = value = this.propertyValues == null ? null : this.propertyValues.get(propertyName);
        if (value == NULL_VALUE) {
            return null;
        }
        if (value != null) {
            return value;
        }
        if (monitor == null) {
            return null;
        }
        DPIController controller = this.context.getDpiController();
        if (controller == null) {
            throw new DBException("No DPI controller in client context");
        }
        if (controller instanceof RestProxy) {
            try {
                Type returnType = null;
                Class<?> localClass = this.dpiClassLoader().loadClass(this.dpiObjectType());
                Method getter = DBXTreeItem.findPropertyReadMethod(localClass, (String)propertyName);
                if (getter != null) {
                    returnType = getter.getGenericReturnType();
                }
                ((RestProxy)controller).setNextCallResultType(returnType);
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.debug((Object)("Cannot resolve local class '" + this.dpiObjectType() + "'"));
            }
        }
        Object propValue = controller.readProperty(this.objectId, propertyName);
        this.cachePropertyValue(propertyName, DPIClientProxy.wrapObjectValue(propValue));
        return propValue;
    }

    @Override
    public Object dpiObjectMethod(@Nullable DBRProgressMonitor monitor, @NotNull String methodName, @Nullable Object[] arguments) throws DBException {
        return this.invokeRemoteMethod(methodName, arguments, null);
    }

    public Object getObjectInstance() {
        return this.objectInstance;
    }

    public String toString() {
        return this.objectToString;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        block23: {
            String methodName = method.getName();
            if (method.getDeclaringClass() == Object.class) {
                if (methodName.equals("toString") && this.objectToString != null) {
                    return this.objectToString;
                }
                if (methodName.equals("hashCode") && this.objectHashCode != null) {
                    return this.objectHashCode;
                }
                return BeanUtils.handleObjectMethod((Object)proxy, (Method)method, (Object[])args);
            }
            if (method.getDeclaringClass() != DPIClientObject.class) break block23;
            switch (methodName) {
                case "dpiObjectId": {
                    return this.dpiObjectId();
                }
                case "dpiObjectType": {
                    return this.dpiObjectType();
                }
                case "dpiClassLoader": {
                    return this.dpiClassLoader();
                }
                case "dpiPropertyValue": {
                    return this.dpiPropertyValue((DBRProgressMonitor)args[0], (String)args[1]);
                }
                case "dpiObjectMethod": {
                    return this.dpiObjectMethod((DBRProgressMonitor)args[0], (String)args[1], (Object[])args[2]);
                }
            }
            log.debug((Object)("Unsupported DPI method '" + methodName + "'"));
            return null;
        }
        Property propAnnotation = method.getAnnotation(Property.class);
        if (propAnnotation != null && this.propertyValues != null && (result = this.propertyValues.get(DPIClientProxy.getPropertyKey(method, propAnnotation))) != null) {
            return DPIClientProxy.unwrapObjectValue(result);
        }
        return null;
    }

    private void cachePropertyValue(String propertyName, Object value) {
        if (this.propertyValues == null) {
            this.propertyValues = new HashMap<String, Object>();
        }
        this.propertyValues.put(propertyName, value);
    }

    private Object invokeRemoteMethod(@NotNull String methodName, @Nullable Object[] args, @Nullable Type returnType) throws DBException {
        DPIController controller = this.context.getDpiController();
        if (controller == null) {
            throw new DBException("No DPI controller in client context");
        }
        if (controller instanceof RestProxy) {
            RestProxy restProxy = (RestProxy)controller;
            restProxy.setNextCallResultType(returnType);
        }
        try {
            log.debug((Object)MessageFormat.format("Call method: {0} object: {1}", methodName, this.objectId));
            Object result = controller.callMethod(this.objectId, methodName, args);
            log.debug((Object)MessageFormat.format("Return method result: {0} object: {1}", methodName, this.objectId));
            return result;
        }
        catch (Throwable e) {
            log.debug((Object)MessageFormat.format("Method invocation error: {0} object: {1}", methodName, this.objectId));
            throw e;
        }
    }

    private static Object wrapObjectValue(Object result) {
        return result == null ? NULL_VALUE : result;
    }

    private static Object unwrapObjectValue(Object result) {
        return result == NULL_VALUE ? null : result;
    }

    private static String getPropertyKey(Method method, Property propAnnotation) {
        String propId = propAnnotation.id();
        if (CommonUtils.isEmpty((String)propId)) {
            propId = BeanUtils.getPropertyNameFromGetter((String)method.getName());
        }
        return propId;
    }
}

