/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.license;

import com.dbeaver.lm.api.LMException;
import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.lm.api.LMLicenseType;
import com.dbeaver.lm.api.LMProduct;
import com.dbeaver.lm.api.LMStatusDetails;
import com.dbeaver.lm.api.LMUtils;
import com.dbeaver.model.license.DBPLicenseService;
import com.dbeaver.model.license.LicensingFeatures;
import com.dbeaver.model.license.app.LMAppUtils;
import com.dbeaver.model.license.embedded.LicenseServiceEmbedded;
import com.dbeaver.ui.license.EapAgreementDialog;
import java.util.Date;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;

public class LicenseMissingDialog
extends IconAndMessageDialog {
    public static final int IMPORT_BUTTON_ID = 1000;
    public static final int TRIAL_BUTTON_ID = 1001;
    public static final int LM_BUTTON_ID = 1002;
    public static final int EAP_BUTTON_ID = 1003;
    private final Throwable validationError;

    public LicenseMissingDialog(Shell parentShell, Throwable validationError) {
        super(parentShell);
        this.validationError = validationError;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        LicenseMissingDialog.applyDialogFont((Control)composite);
        try {
            String shortMessage;
            DBPLicenseService licenseService = LMAppUtils.getLicenseService();
            LMProduct product = LMAppUtils.getActiveProduct();
            LMLicense[] productLicenses = licenseService.getAllProductLicenses();
            LMLicense lastLicense = null;
            Date mostRecentDate = null;
            LMLicense[] lMLicenseArray = productLicenses;
            int n = productLicenses.length;
            int n2 = 0;
            while (n2 < n) {
                LMLicense license = lMLicenseArray[n2];
                if (mostRecentDate == null || license.getLicenseType() != LMLicenseType.TRIAL || license.getLicenseStartTime().compareTo(mostRecentDate) > 0) {
                    lastLicense = license;
                    mostRecentDate = license.getLicenseStartTime();
                }
                ++n2;
            }
            if (lastLicense == null) {
                shortMessage = "No license found";
                this.message = "License for '" + product.getName() + "' not found.\nYou need to import a valid license or obtain a new one.";
            } else if (this.validationError != null) {
                shortMessage = "License validation failed";
                this.message = CommonUtils.notEmpty((String)this.validationError.getMessage());
            } else {
                LMStatusDetails licenseStatus = lastLicense.getLicenseStatus(product);
                shortMessage = licenseStatus.getMessage();
                this.message = licenseStatus.getDetails();
            }
            this.getShell().setText(shortMessage);
            Composite msgPlaceholder = UIUtils.createPlaceholder((Composite)composite, (int)2, (int)5);
            super.createMessageArea(msgPlaceholder);
            Group licenseGroup = UIUtils.createControlGroup((Composite)composite, (String)"License", (int)2, (int)1808, (int)0);
            Text productText = UIUtils.createLabelText((Composite)licenseGroup, (String)"Product", (String)(product.getName() + " " + product.getVersion()), (int)2056);
            productText.setLayoutData((Object)new GridData(768));
            if (lastLicense != null) {
                Text licenseText = UIUtils.createLabelText((Composite)licenseGroup, (String)"License", (String)(lastLicense.getLicenseId() + " - " + lastLicense.getLicenseType().getDisplayName() + ", starts on " + LMUtils.HR_DATE_FORMAT.format(lastLicense.getLicenseStartTime())), (int)2056);
                licenseText.setLayoutData((Object)new GridData(768));
            }
            Link label = new Link((Composite)licenseGroup, 0);
            if (lastLicense == null) {
                label.setText("If you have a product license then you can import it by pressing the Import button.\nYou can buy a license on DBeaver <a href=\"https://dbeaver.com/buy/?utm_source=app&utm_medium=nolicense&utm_campaign=buy\">web site</a> or you can use a trial license.");
            } else if (lastLicense.getLicenseType() == LMLicenseType.TRIAL) {
                label.setText("You can buy a license on the official <a href=\"https://dbeaver.com/buy/?utm_source=app&utm_medium=license-expired&utm_campaign=trial\">web site</a>.\n");
                LicensingFeatures.TRIAL_EXPIRED_POPUP_SHOWN.use();
            } else {
                label.setText("You can renew the license on the official <a href=\"https://dbeaver.com/buy/?utm_source=app&utm_medium=license-expired&utm_campaign=paid\">web site</a>.\n");
                LicensingFeatures.TRIAL_EXPIRED_POPUP_SHOWN.use();
            }
            label.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UIUtils.openWebBrowser((String)e.text);
                }
            });
            GridData gd = new GridData(1808);
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
            if (LicenseMissingDialog.canJoinEap(lastLicense)) {
                Group eapGroup = UIUtils.createControlGroup((Composite)composite, (String)"Early access program", (int)1, (int)1808, (int)0);
                Link eapLink = new Link((Composite)eapGroup, 0);
                eapLink.setText("Alternatively, you can participate in Early Access Program and get free access to\npre-release versions of DBeaver. You can read more about it <a>here</a>.");
                eapLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Early-access-program"));
                    }
                });
                Button joinEapButton = UIUtils.createDialogButton((Composite)eapGroup, (String)"Join Early Access Program", (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.buttonPressed(1003)));
                GridDataFactory.createFrom((GridData)((GridData)joinEapButton.getLayoutData())).align(131072, 0x1000000).grab(true, false).applyTo((Control)joinEapButton);
            }
        }
        catch (LMException e2) {
            DBWorkbench.getPlatformUI().showError("Error getting license info", "Error getting license info", (Throwable)e2);
        }
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 1002, "License Manager", true);
        button.setLayoutData((Object)new GridData(768));
        this.createButton(parent, 1000, "Import license", true);
        if (LicenseMissingDialog.canRequestTrial()) {
            this.createButton(parent, 1001, "Trial", false);
        }
        this.createButton(parent, 1, "Exit", false);
    }

    protected Image getImage() {
        return DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_ERROR);
    }

    protected int getColumnCount() {
        return 1;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1002: {
                this.setReturnCode(1002);
                this.close();
                return;
            }
            case 1000: {
                this.setReturnCode(1000);
                this.close();
                return;
            }
            case 1001: {
                try {
                    if (((LicenseServiceEmbedded)LMAppUtils.getLicenseService()).findTrialLicense() == null) {
                        this.setReturnCode(1001);
                        this.close();
                    } else {
                        MessageBox messageBox = new MessageBox(this.getShell(), 1);
                        messageBox.setText("Can't generate trial license");
                        messageBox.setMessage("You can't generate second trial license. Old one has expired");
                        messageBox.open();
                    }
                }
                catch (LMException e) {
                    DBWorkbench.getPlatformUI().showError("Error reading trial license", "Bad trial license", (Throwable)e);
                }
                return;
            }
            case 1003: {
                EapAgreementDialog dialog = new EapAgreementDialog(this.getShell());
                if (dialog.open() == 0) {
                    this.setReturnCode(1003);
                    this.close();
                }
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    private static boolean canJoinEap(@Nullable LMLicense lastLicense) {
        return lastLicense != null && lastLicense.getLicenseType() == LMLicenseType.TRIAL;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean canRequestTrial() {
        void service;
        DBPLicenseService dBPLicenseService = LMAppUtils.getLicenseService();
        if (!(dBPLicenseService instanceof LicenseServiceEmbedded)) {
            return false;
        }
        LicenseServiceEmbedded licenseServiceEmbedded = (LicenseServiceEmbedded)dBPLicenseService;
        LMProduct product = service.getActiveProduct();
        LMLicense[] lMLicenseArray = service.getAllProductLicenses();
        int n = lMLicenseArray.length;
        int n2 = 0;
        while (n2 < n) {
            LMLicense license = lMLicenseArray[n2];
            if (license.getLicenseType() == LMLicenseType.TRIAL && license.getProductVersion().equals(product.getVersion())) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

