/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.license;

import com.dbeaver.lm.api.LMLicense;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.utils.Base64;
import org.jkiss.utils.IOUtils;

public class LicenseExportDialog
extends BaseDialog {
    private final LMLicense licence;
    private Text licenseText;

    public LicenseExportDialog(Shell parentShell, LMLicense licence) {
        super(parentShell, "Export License", null);
        this.licence = licence;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Label infoLabel = new Label(composite, 0);
        infoLabel.setLayoutData((Object)new GridData(768));
        infoLabel.setText("Copy/paste license text or save it from file");
        Group licenseGroup = UIUtils.createControlGroup((Composite)composite, (String)"License text", (int)1, (int)1808, (int)0);
        this.licenseText = new Text((Composite)licenseGroup, 2562);
        GridData gd = new GridData(1808);
        gd.heightHint = this.licenseText.getLineHeight() * 6;
        gd.widthHint = this.licenseText.getLineHeight() * 30;
        this.licenseText.setLayoutData((Object)gd);
        String exportText = Base64.splitLines((String)Base64.encode((byte[])this.licence.getEncoded()), (int)76);
        this.licenseText.setText(exportText);
        Composite buttonsBar = UIUtils.createPlaceholder((Composite)licenseGroup, (int)2, (int)5);
        UIUtils.createPushButton((Composite)buttonsBar, (String)"Copy", (Image)PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_COPY")).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseExportDialog.this.copyLicenseToClipboard();
            }
        });
        UIUtils.createPushButton((Composite)buttonsBar, (String)"Save", (Image)PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE")).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseExportDialog.this.saveLicenseToFile();
            }
        });
        return parent;
    }

    private void saveLicenseToFile() {
        String licenseText = this.licenseText.getText();
        File file = DialogUtils.selectFileForSave((Shell)this.getShell(), (String)"License file");
        if (file != null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileWriter os = new FileWriter(file);){
                    IOUtils.copyText((Reader)new StringReader(licenseText), (Writer)os);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                DBWorkbench.getPlatformUI().showError("Save license", "Error saving license to file", (Throwable)e);
            }
        }
    }

    private void copyLicenseToClipboard() {
        UIUtils.setClipboardContents((Display)Display.getCurrent(), (Transfer)TextTransfer.getInstance(), (Object)this.licenseText.getText());
    }
}

