/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.aws.ssm;

import com.dbeaver.model.net.AbstractCommandLineTunnel;
import com.dbeaver.net.auth.aws.AuthModelAWSAbstract;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import com.dbeaver.net.auth.aws.AuthModelAWSPreferences;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWUtils;
import org.jkiss.dbeaver.model.runtime.DBRProcessDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class SSMTunnelImpl
extends AbstractCommandLineTunnel {
    private static final Log log = Log.getLog(SSMTunnelImpl.class);
    private AuthModelAWSCredentials awsCredentials;

    protected Process createTunnelProcess(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration, @NotNull DBPConnectionConfiguration connectionInfo, int localPort) throws DBException {
        monitor.subTask("Initiate SSM session");
        try {
            Path awsClipFolder;
            String instanceId = configuration.getStringProperty("ssm.instance.id");
            String regionName = configuration.getStringProperty("ssm.instance.region");
            if (CommonUtils.isEmpty((String)instanceId)) {
                throw new DBException("AWS EC2 instance not specified");
            }
            if (CommonUtils.isEmpty((String)regionName)) {
                throw new DBException("AWS region not specified");
            }
            this.awsCredentials = new AuthModelAWSCredentials();
            AuthModelAWSAbstract.loadCredentialsFromMap(this.awsCredentials, configuration.getSecureProperties());
            this.awsCredentials.setRegion(regionName);
            String hostName = connectionInfo.getHostName();
            boolean isRemoteHost = !DBWUtils.isLocalAddress((String)hostName);
            LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
            if (isRemoteHost) {
                params.put("host", List.of(hostName));
            }
            params.put("portNumber", List.of(String.valueOf(SSMTunnelImpl.getDefaultRemotePort((DBWHandlerConfiguration)configuration))));
            params.put("localPortNumber", List.of(String.valueOf(localPort)));
            String documentName = configuration.getStringProperty("ssm.document");
            if (CommonUtils.isEmpty((String)documentName)) {
                documentName = isRemoteHost ? "AWS-StartPortForwardingSessionToRemoteHost" : "AWS-StartPortForwardingSession";
            }
            monitor.subTask("Initialize SSM over AWS CLI");
            this.awsCredentials.getAuthCredentialsProvider(monitor, connectionInfo);
            ArrayList<String> arguments = new ArrayList<String>();
            String awsCliExecutablePath = AuthModelAWSCredentials.getAwsCliExecutablePath();
            arguments.add(awsCliExecutablePath);
            arguments.add("ssm");
            arguments.add("start-session");
            arguments.add("--target");
            arguments.add(instanceId);
            arguments.add("--region");
            arguments.add(this.awsCredentials.getRegion());
            arguments.add("--document-name");
            arguments.add(documentName);
            String ssmParameters = new GsonBuilder().serializeNulls().create().toJson(params, Map.class);
            arguments.add("--parameters");
            arguments.add(SSMTunnelImpl.escapeCLIIdentifier(ssmParameters));
            this.addCredentialArguments(arguments);
            log.debug((Object)"Execute AWS CLI ssm");
            DBRProcessDescriptor cliProcess = SSMTunnelImpl.createProcessByArguments(arguments);
            this.addCredentialEnvironment(cliProcess);
            String ssmPluginPath = AuthModelAWSPreferences.getPreferences().getString("aws.ssm.plugin.folder");
            if (CommonUtils.isEmpty((String)ssmPluginPath) && (awsClipFolder = Path.of(awsCliExecutablePath, new String[0]).getParent()) != null && awsClipFolder.getParent() != null) {
                ssmPluginPath = awsClipFolder.getParent().resolve("SessionManagerPlugin").resolve("bin").toAbsolutePath().toString();
            }
            if (!CommonUtils.isEmpty((String)ssmPluginPath) && Files.exists(Path.of(ssmPluginPath, new String[0]), new LinkOption[0])) {
                cliProcess.getProcessBuilder().environment().put("PATH", ssmPluginPath + File.pathSeparator + System.getenv("PATH"));
            }
            try {
                cliProcess.execute();
            }
            catch (Throwable e) {
                Process process = cliProcess.getProcess();
                if (process != null) {
                    process.destroy();
                }
                throw new DBCException("Error running AWS CLI. Is it installed on the local machine?", e);
            }
            return cliProcess.getProcess();
        }
        catch (Exception e) {
            throw new DBException("AWS SSM session initiation filed", (Throwable)e);
        }
    }

    private void addCredentialArguments(List<String> arguments) {
        if (!CommonUtils.isEmpty((String)this.awsCredentials.getProfileName())) {
            arguments.add("--profile");
            arguments.add(this.awsCredentials.getProfileName());
        }
    }

    private void addCredentialEnvironment(@NotNull DBRProcessDescriptor cliProcess) {
        if (!CommonUtils.isEmpty((String)this.awsCredentials.getAwsAccessKey())) {
            cliProcess.getProcessBuilder().environment().put("AWS_ACCESS_KEY_ID", this.awsCredentials.getAwsAccessKey());
            cliProcess.getProcessBuilder().environment().put("AWS_SECRET_ACCESS_KEY", this.awsCredentials.getAwsSecretKey());
            if (CommonUtils.isNotEmpty((String)this.awsCredentials.getAwsSessionToken())) {
                cliProcess.getProcessBuilder().environment().put("AWS_SESSION_TOKEN", this.awsCredentials.getAwsSessionToken());
            }
        }
    }

    public void closeTunnel(@NotNull DBRProgressMonitor monitor) throws DBException, IOException {
        Process forwardPortProccess = this.getForwardPortProccess();
        if (this.awsCredentials != null && forwardPortProccess != null && forwardPortProccess.isAlive()) {
            String sessionId;
            block13: {
                sessionId = null;
                Pattern sidPattern = Pattern.compile("Starting session with SessionId:\\s*(.+)\\s*", 2);
                Throwable throwable = null;
                Object var6_7 = null;
                try (BufferedReader input = new BufferedReader(new InputStreamReader(forwardPortProccess.getInputStream()));){
                    String line;
                    Matcher matcher;
                    do {
                        if ((line = input.readLine()) != null) continue;
                        break block13;
                    } while (!(matcher = sidPattern.matcher(line)).find());
                    sessionId = matcher.group(1);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (!CommonUtils.isEmpty(sessionId)) {
                ArrayList<String> arguments = new ArrayList<String>();
                arguments.add(AuthModelAWSCredentials.getAwsCliExecutablePath());
                arguments.add("ssm");
                arguments.add("terminate-session");
                arguments.add("--session-id ");
                arguments.add(sessionId);
                if (!CommonUtils.isEmpty((String)this.awsCredentials.getProfileName())) {
                    this.addCredentialArguments(arguments);
                }
                monitor.subTask("Terminating AWS SSM session");
                DBRProcessDescriptor cliProcess = SSMTunnelImpl.createProcessByArguments(arguments);
                this.addCredentialEnvironment(cliProcess);
                cliProcess.execute();
            }
        }
        super.closeTunnel(monitor);
    }

    public static String escapeCLIIdentifier(String name) {
        if (RuntimeUtils.isWindows()) {
            return "\"" + name.replace("\"", "\"\"") + "\"";
        }
        return name;
    }
}

