/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.databricks.ui;

import com.dbeaver.db.databricks.ui.DatabricksUIMessages;
import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class DatabricksConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private Text urlText;
    private Text hostText;
    private Text portText;
    private Text databaseText;
    private boolean activated = false;

    public void createControl(Composite composite) {
        Composite mainGroup = new Composite(composite, 0);
        mainGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        mainGroup.setLayoutData((Object)gd);
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.updateUrl();
                this.site.updateButtons();
            }
        };
        Group addrGroup = UIUtils.createControlGroup((Composite)mainGroup, (String)UIConnectionMessages.dialog_connection_server_label, (int)4, (int)768, (int)0);
        SelectionAdapter typeSwitcher = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabricksConnectionPage.this.setupConnectionModeSelection(DatabricksConnectionPage.this.urlText, DatabricksConnectionPage.this.typeURLRadio.getSelection(), GROUP_CONNECTION_ARR);
                DatabricksConnectionPage.this.updateUrl();
            }
        };
        this.createConnectionModeSwitcher((Composite)addrGroup, (SelectionListener)typeSwitcher);
        UIUtils.createControlLabel((Composite)addrGroup, (String)UIConnectionMessages.dialog_connection_url_label);
        this.urlText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 355;
        this.urlText.setLayoutData((Object)gd);
        this.urlText.addModifyListener(e -> this.site.updateButtons());
        Label hostLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)UIConnectionMessages.dialog_connection_host_label);
        this.hostText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)gd);
        UIUtils.setDefaultTextControlWidthHint((Control)this.hostText);
        this.hostText.addModifyListener(textListener);
        this.addControlToGroup("connection", new Control[]{hostLabel, this.hostText});
        Label portLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)DatabricksUIMessages.databricks_connection_port_label);
        this.portText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(2);
        gd.widthHint = UIUtils.getFontHeight((Control)this.portText) * 7;
        this.portText.setLayoutData((Object)gd);
        this.portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.portText.addModifyListener(textListener);
        this.addControlToGroup("connection", new Control[]{portLabel, this.portText});
        Label pathLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)DatabricksUIMessages.databricks_connection_database_label);
        this.databaseText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.databaseText.setLayoutData((Object)gd);
        UIUtils.setDefaultTextControlWidthHint((Control)this.databaseText);
        this.databaseText.addModifyListener(textListener);
        this.addControlToGroup("connection", new Control[]{pathLabel, this.databaseText});
        this.createAuthPanel(mainGroup, 1);
        this.createDriverPanel(mainGroup);
        this.setControl((Control)mainGroup);
    }

    protected void createDriverSubstitutionControls(@NotNull Composite parent) {
    }

    public boolean isComplete() {
        if (this.isCustomURL()) {
            return !CommonUtils.isEmpty((String)this.urlText.getText());
        }
        return this.hostText != null && !CommonUtils.isEmpty((String)this.hostText.getText());
    }

    public void loadSettings() {
        boolean useURL;
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        boolean isLegacyManualConnectionType = connectionInfo.getConfigurationType() == DBPDriverConfigurationType.MANUAL && CommonUtils.isEmpty((String)connectionInfo.getHostPort()) && CommonUtils.isEmpty((String)connectionInfo.getHostName()) && CommonUtils.isEmpty((String)connectionInfo.getDatabaseName()) && CommonUtils.isNotEmpty((String)connectionInfo.getUrl());
        boolean bl = useURL = connectionInfo.getConfigurationType() == DBPDriverConfigurationType.URL;
        if (connectionInfo.getConfigurationType() == DBPDriverConfigurationType.URL || isLegacyManualConnectionType) {
            if (this.urlText != null) {
                if ((useURL || isLegacyManualConnectionType) && CommonUtils.isNotEmpty((String)connectionInfo.getUrl())) {
                    this.urlText.setText(connectionInfo.getUrl());
                }
                if (this.typeURLRadio != null && this.typeManualRadio != null) {
                    this.typeURLRadio.setSelection(true);
                    this.typeManualRadio.setSelection(false);
                }
            }
        } else {
            if (this.hostText != null) {
                this.hostText.setText(CommonUtils.notEmpty((String)connectionInfo.getHostName()));
            }
            if (this.portText != null) {
                if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                    this.portText.setText(connectionInfo.getHostPort());
                } else if (this.site.getDriver().getDefaultPort() != null) {
                    this.portText.setText(this.site.getDriver().getDefaultPort());
                } else {
                    this.portText.setText("443");
                }
            }
            if (this.databaseText != null) {
                this.databaseText.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
            }
        }
        this.setupConnectionModeSelection(this.urlText, isLegacyManualConnectionType || useURL, GROUP_CONNECTION_ARR);
        this.updateUrl();
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.typeURLRadio != null) {
            connectionInfo.setConfigurationType(this.typeURLRadio.getSelection() ? DBPDriverConfigurationType.URL : DBPDriverConfigurationType.MANUAL);
        }
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        if (this.databaseText != null) {
            connectionInfo.setDatabaseName(this.databaseText.getText().trim());
        }
        if (this.typeURLRadio != null && this.typeURLRadio.getSelection()) {
            connectionInfo.setUrl(this.urlText.getText());
        }
        super.saveSettings(dataSource);
    }

    private void updateUrl() {
        DBPDataSourceContainer dataSourceContainer = this.site.getActiveDataSource();
        this.saveSettings(dataSourceContainer);
        if (this.typeURLRadio != null && this.typeURLRadio.getSelection()) {
            String connectionUrl = dataSourceContainer.getConnectionConfiguration().getUrl();
            if (CommonUtils.isNotEmpty((String)connectionUrl)) {
                this.urlText.setText(connectionUrl);
            }
        } else {
            String connectionURL = dataSourceContainer.getDriver().getConnectionURL(dataSourceContainer.getConnectionConfiguration());
            if (CommonUtils.isNotEmpty((String)connectionURL)) {
                this.urlText.setText(connectionURL);
            }
        }
    }

    @Nullable
    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

