/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.xml;

import com.dbeaver.jdbc.files.FFFileReader;
import com.dbeaver.jdbc.files.xml.XmlNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.stream.XMLStreamReader;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class XmlReader
implements FFFileReader<XmlNode> {
    @NotNull
    private final XMLStreamReader streamReader;
    private final AtomicBoolean tableOpened = new AtomicBoolean(false);
    @Nullable
    private String tableName;

    public XmlReader(@NotNull XMLStreamReader streamReader) {
        this.streamReader = streamReader;
    }

    public boolean openNextTable() throws IOException {
        try {
            while (this.streamReader.hasNext()) {
                int next = this.streamReader.next();
                if (next != 1) continue;
                this.tableName = this.streamReader.getLocalName();
                return this.tableOpened.compareAndSet(false, true);
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to read XML file", e);
        }
        return false;
    }

    @Nullable
    public String getCurrentTable() {
        return this.tableName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public XmlNode[] readRow() throws IOException {
        try {
            String rowTag = null;
            String columnTag = null;
            ArrayList<XmlNode> row = new ArrayList<XmlNode>();
            StringBuilder text = new StringBuilder();
            block7: while (this.streamReader.hasNext()) {
                int next = this.streamReader.next();
                switch (next) {
                    case 1: {
                        String localName = this.streamReader.getLocalName();
                        if (rowTag == null) {
                            rowTag = localName;
                            row.addAll(this.getAttributes());
                            break;
                        }
                        if (columnTag != null) {
                            throw new IOException("Invalid XML format");
                        }
                        columnTag = localName;
                        break;
                    }
                    case 4: {
                        if (columnTag == null) continue block7;
                        text.append(this.streamReader.getText());
                        break;
                    }
                    case 2: {
                        String localName = this.streamReader.getLocalName();
                        if (localName.equals(columnTag)) {
                            row.add(new XmlNode(columnTag, text.toString()));
                            text.setLength(0);
                            columnTag = null;
                            break;
                        }
                        if (localName.equals(rowTag)) {
                            return row.toArray(new XmlNode[0]);
                        }
                        if (localName.equals(this.tableName)) {
                            return null;
                        }
                        throw new IOException("Invalid XML format");
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new IOException("Failed to read XML file", e);
        }
    }

    private List<XmlNode> getAttributes() {
        ArrayList<XmlNode> attributes = new ArrayList<XmlNode>();
        int i = 0;
        while (i < this.streamReader.getAttributeCount()) {
            attributes.add(new XmlNode(this.streamReader.getAttributeLocalName(i), this.streamReader.getAttributeValue(i)));
            ++i;
        }
        return attributes;
    }

    public void close() throws IOException {
        try {
            this.streamReader.close();
        }
        catch (Exception e) {
            throw new IOException("Failed to close XML file", e);
        }
    }
}

