/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.xml;

import com.dbeaver.jdbc.files.FFDataFileMetadataReader;
import com.dbeaver.jdbc.files.FFDataSourceScanner;
import com.dbeaver.jdbc.files.FFDataSourceScannerFactory;
import com.dbeaver.jdbc.files.FFDataSourceScannerImpl;
import com.dbeaver.jdbc.files.FFExternalMetadataReader;
import com.dbeaver.jdbc.files.FFExternalMetadataReaderImpl;
import com.dbeaver.jdbc.files.FFFileScannerFactory;
import com.dbeaver.jdbc.files.FFFileScannerImpl;
import com.dbeaver.jdbc.files.FFOrderMappingStrategy;
import com.dbeaver.jdbc.files.FFPropertiesFactory;
import com.dbeaver.jdbc.files.FFStructureMappingStrategy;
import com.dbeaver.jdbc.files.FFTableNameFactory;
import com.dbeaver.jdbc.files.FFTablePropertiesParser;
import com.dbeaver.jdbc.files.FFTableReaderFactory;
import com.dbeaver.jdbc.files.GenericTableNameFactory;
import com.dbeaver.jdbc.files.api.FFConnection;
import com.dbeaver.jdbc.files.api.FFDataSource;
import com.dbeaver.jdbc.files.api.FFDataSourceFormat;
import com.dbeaver.jdbc.files.api.FFDatabaseMetaData;
import com.dbeaver.jdbc.files.api.FFJdbcDriver;
import com.dbeaver.jdbc.files.database.FFDatabase;
import com.dbeaver.jdbc.files.xml.XmlDatabaseMetaData;
import com.dbeaver.jdbc.files.xml.XmlFileReaderFactory;
import com.dbeaver.jdbc.files.xml.XmlMetadataReader;
import com.dbeaver.jdbc.files.xml.XmlNode;
import com.dbeaver.jdbc.files.xml.XmlProperties;
import com.dbeaver.jdbc.files.xml.XmlTableProperties;
import com.dbeaver.jdbc.files.xml.XmlTablePropertiesParser;
import com.dbeaver.jdbc.files.xml.XmlTableReaderFactory;
import java.io.IOException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.jkiss.code.NotNull;

public class XmlJdbcDriver
extends FFJdbcDriver<XmlNode, XmlTableProperties, XmlProperties> {
    public static final String DRIVER_NAME = "DBeaver XML JDBC Driver";
    public static final String DRIVER_PREFIX = "jdbc:dbeaver:file:xml:";
    public static final int DRIVER_VERSION_MAJOR = 1;
    public static final int DRIVER_VERSION_MINOR = 0;

    static {
        try {
            DriverManager.registerDriver((Driver)((Object)new XmlJdbcDriver()));
        }
        catch (SQLException e) {
            throw new RuntimeException("Error registering driver", e);
        }
    }

    public XmlJdbcDriver() {
        super(DRIVER_PREFIX, 1, 0);
    }

    @NotNull
    protected FFDatabaseMetaData createDatabaseMetaData(@NotNull FFConnection connection, @NotNull String url, @NotNull FFDatabase database) {
        return new XmlDatabaseMetaData(connection, url, database, this.getPropertiesFactory());
    }

    @NotNull
    public FFDataSourceFormat getSupportedDataSourceFormat() {
        return FFDataSourceFormat.XML;
    }

    @NotNull
    public FFFileScannerFactory<XmlNode, XmlTableProperties, XmlProperties> getFileScannerFactory() {
        return (dataSource, connectionClosedFuture) -> {
            XmlFileReaderFactory readerFactory = new XmlFileReaderFactory();
            return new FFFileScannerImpl((FFTableNameFactory)new GenericTableNameFactory(dataSource), (FFDataFileMetadataReader)new XmlMetadataReader((XmlProperties)dataSource.properties(), readerFactory), (FFExternalMetadataReader)new FFExternalMetadataReaderImpl((FFTablePropertiesParser)new XmlTablePropertiesParser()), (FFTableReaderFactory)new XmlTableReaderFactory(readerFactory, (XmlProperties)dataSource.properties()), (FFStructureMappingStrategy)new FFOrderMappingStrategy());
        };
    }

    @NotNull
    public FFDataSourceScannerFactory<XmlNode, XmlTableProperties, XmlProperties> getDataSourceScannerFactory() {
        return new FFDataSourceScannerFactory<XmlNode, XmlTableProperties, XmlProperties>(){

            @NotNull
            public FFDataSourceScanner<XmlNode, XmlTableProperties, XmlProperties> createDataSourceScanner(@NotNull FFDataSource<XmlProperties> dataSource, @NotNull CompletableFuture<Void> connectionClosedFuture) throws IOException {
                return new FFDataSourceScannerImpl(XmlJdbcDriver.this.getFileScannerFactory().createScanner(dataSource, connectionClosedFuture));
            }
        };
    }

    @NotNull
    public FFPropertiesFactory<XmlProperties> getPropertiesFactory() {
        return new FFPropertiesFactory<XmlProperties>(){

            public XmlProperties createProperties(Properties properties) {
                return new XmlProperties(properties);
            }

            public XmlProperties createProperties(Map<String, String> properties) {
                return new XmlProperties(properties);
            }
        };
    }

    public String getDriverIdentifier() {
        return DRIVER_NAME;
    }
}

