/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.internal.preferences.security;

import com.dbeaver.ee.runtime.core.DBeaverEnterprisePreferences;
import com.dbeaver.model.DBPProjectAdvanced;
import com.dbeaver.ui.internal.UICoreMessages;
import com.dbeaver.ui.internal.preferences.security.AdvancedPreferences;
import com.dbeaver.ui.security.PasswordProviderUtils;
import com.dbeaver.ui.security.PasswordProvidersInfo;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.internal.security.storage.friends.InternalExchangeUtils;
import org.eclipse.equinox.internal.security.storage.friends.PasswordProviderDescription;
import org.eclipse.equinox.internal.security.storage.friends.ReEncrypter;
import org.eclipse.equinox.internal.security.ui.nls.SecUIMessages;
import org.eclipse.equinox.internal.security.ui.storage.ChangePasswordWizardDialog;
import org.eclipse.equinox.internal.security.ui.storage.PasswordRecoveryDialog;
import org.eclipse.equinox.internal.security.ui.storage.StorageUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.impl.app.BaseWorkspaceImpl;
import org.jkiss.dbeaver.model.secret.DBSSecretBrowser;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.PreferencePageDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.service.prefs.BackingStoreException;

public class SecureStoragePreferences {
    private static final Log log = Log.getLog(DataSourceDescriptor.class);
    private static final int PARENT_COLUMNS = 2;
    private final int widthHint;
    private Button buttonChangePassword;
    private Button buttonRecoverPassword;
    private Button secureStorageCheckbox;
    private boolean providerModified = false;
    private boolean secureStorageToggled = false;
    private PasswordProviderDescription selectedProvider;

    SecureStoragePreferences(@NotNull Composite parent, int widthHint) {
        this.widthHint = widthHint;
        this.createSecretData(parent);
        this.createEncryptionMethod(parent);
    }

    private void createSecretData(Composite parent) {
        Group secretDataGroup = UIUtils.createControlGroup((Composite)parent, (String)UICoreMessages.pref_page_security_group_secret_data, (int)1, (int)32, (int)this.widthHint);
        UIUtils.createInfoLink((Composite)secretDataGroup, (String)UICoreMessages.pref_page_security_group_secret_data_hint, () -> {
            boolean bl = ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Managing-Master-Password"));
        }, (int)64, (int)2, (int)-1);
        Button globalSettings = UIUtils.createCheckbox((Composite)secretDataGroup, (String)UICoreMessages.pref_page_security_data_global, (String)UICoreMessages.pref_page_security_data_global_hint, (boolean)true, (int)1);
        GridData gd = new GridData(32);
        gd.horizontalIndent = 20;
        globalSettings.setLayoutData((Object)gd);
        globalSettings.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (!globalSettings.getSelection()) {
                globalSettings.setSelection(true);
                UIUtils.showMessageBox((Shell)parent.getShell(), (String)UICoreMessages.pref_page_security_data_global, (String)"This option cannot be turned off.\nGlobal secure settings must be stored in the encrypted storage", (int)1);
            }
        }));
        this.secureStorageCheckbox = UIUtils.createCheckbox((Composite)secretDataGroup, (String)UICoreMessages.pref_page_security_data_database_credentials, (String)UICoreMessages.pref_page_security_data_database_credentials_hint, (boolean)this.isSecureDatabaseCredentials(), (int)1);
        this.secureStorageCheckbox.setLayoutData((Object)gd);
        this.secureStorageCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.secureStorageToggled = this.isSecureDatabaseCredentials() ^ this.secureStorageCheckbox.getSelection();
        }));
        this.addSecureStorageButton((Composite)secretDataGroup);
        UIUtils.createInfoLink((Composite)secretDataGroup, (String)UICoreMessages.pref_page_security_group_secret_type_hint, () -> {
            boolean bl = ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Managing-Master-Password"));
        }, (int)64, (int)2, (int)-1);
    }

    private void createEncryptionMethod(@NotNull Composite parent) {
        Group encryptionMethodGroup = UIUtils.createControlGroup((Composite)parent, (String)UICoreMessages.pref_page_security_group_encryption_method, (int)2, (int)32, (int)this.widthHint);
        encryptionMethodGroup.setLayoutData((Object)new GridData(32));
        this.addPasswordProviderSelector((Composite)encryptionMethodGroup);
        this.addPasswordManagementComposite((Composite)encryptionMethodGroup);
    }

    private void addPasswordProviderSelector(Composite preferencesGroup) {
        Composite passwordProviderComposite = UIUtils.createComposite((Composite)preferencesGroup, (int)1);
        passwordProviderComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        PasswordProvidersInfo pi = PasswordProviderUtils.loadPasswordProviderSettings();
        this.selectedProvider = pi.selectedProvider();
        PasswordProviderDescription[] passwordProviderDescriptionArray = pi.providers();
        int n = passwordProviderDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PasswordProviderDescription pp = passwordProviderDescriptionArray[n2];
            Button toggle = UIUtils.createRadioButton((Composite)passwordProviderComposite, (String)pp.getName(), (Object)pp, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> {
                Button button;
                if (e.widget instanceof Button && (button = (Button)e.widget).getSelection()) {
                    this.providerModified = pp != this.selectedProvider;
                    this.selectedProvider = pp;
                    this.refreshChangePasswordButton();
                    this.refreshRecoveredPasswordButton();
                }
            }));
            toggle.setSelection(pp == this.selectedProvider);
            Label label = new Label(passwordProviderComposite, 64);
            label.setText(CommonUtils.notEmpty((String)pp.getDescription()));
            GridData lgd = new GridData(32);
            lgd.widthHint = this.widthHint - 30;
            lgd.horizontalIndent = 20;
            label.setLayoutData((Object)lgd);
            ++n2;
        }
    }

    private void addPasswordManagementComposite(Composite parent) {
        Composite passwordManagementComposite = UIUtils.createComposite((Composite)parent, (int)3);
        passwordManagementComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 2).create());
        this.addChangePasswordButton(passwordManagementComposite, parent.getShell());
        this.addRecoverPasswordButton(passwordManagementComposite, parent.getShell());
        this.addRemovePasswordButton(passwordManagementComposite, parent.getShell());
    }

    private void addChangePasswordButton(Composite parent, final Shell shell) {
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                PasswordProviderDescription selectedPasswordProvider = SecureStoragePreferences.this.selectedProvider;
                if (selectedPasswordProvider == null) {
                    return;
                }
                String moduleID = selectedPasswordProvider.getId();
                ISecurePreferences rootNode = SecurePreferencesFactory.getDefault();
                if (selectedPasswordProvider.hasHint("AutomaticPasswordGeneration")) {
                    SecureStoragePreferences.this.changePassword(rootNode, moduleID, selectedPasswordProvider.getName(), shell);
                } else {
                    ChangePasswordWizardDialog dialog = new ChangePasswordWizardDialog(shell, rootNode, moduleID);
                    dialog.open();
                    SecureStoragePreferences.this.refreshRecoveredPasswordButton();
                }
            }
        };
        this.buttonChangePassword = UIUtils.createDialogButton((Composite)parent, (String)UICoreMessages.pref_page_security_change_password_button, (SelectionListener)listener);
        this.setButtonSize(this.buttonChangePassword);
        this.refreshChangePasswordButton();
    }

    private void refreshChangePasswordButton() {
        this.buttonChangePassword.setEnabled(this.isDbeaverPasswordProvider(this.selectedProvider));
    }

    private void addRecoverPasswordButton(Composite parent, final Shell shell) {
        this.buttonRecoverPassword = new Button(parent, 8);
        this.buttonRecoverPassword.setText(UICoreMessages.pref_page_security_recover_password_button);
        this.buttonRecoverPassword.setLayoutData((Object)new GridData(1, 1, false, false));
        this.buttonRecoverPassword.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                PasswordProviderDescription selectedPasswordProvider = SecureStoragePreferences.this.selectedProvider;
                if (selectedPasswordProvider == null) {
                    return;
                }
                String moduleID = selectedPasswordProvider.getId();
                ISecurePreferences rootNode = SecurePreferencesFactory.getDefault();
                String[] questions = InternalExchangeUtils.getPasswordRecoveryQuestions((ISecurePreferences)rootNode, (String)moduleID);
                if (questions.length == 0) {
                    return;
                }
                PasswordRecoveryDialog dialog = new PasswordRecoveryDialog(questions, shell, moduleID);
                dialog.open();
            }
        });
        this.setButtonSize(this.buttonRecoverPassword);
        this.refreshRecoveredPasswordButton();
    }

    private void refreshRecoveredPasswordButton() {
        this.buttonRecoverPassword.setEnabled(PasswordProviderUtils.hasHints(this.selectedProvider));
    }

    private void addRemovePasswordButton(Composite parent, Shell shell) {
        Button buttonRemovePassword = new Button(parent, 8);
        buttonRemovePassword.setText(UICoreMessages.pref_page_security_remove_password_button);
        buttonRemovePassword.setLayoutData((Object)new GridData(1, 1, false, false));
        buttonRemovePassword.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (UIUtils.confirmAction((Shell)shell, (String)UICoreMessages.pref_page_security_remove_password_title, (String)UICoreMessages.pref_page_security_remove_password_text)) {
                PasswordProviderUtils.deleteDefaultStorage();
            }
        }));
        this.setButtonSize(buttonRemovePassword);
    }

    private void addSecureStorageButton(Composite parent) {
        Button buttonAdvanced = UIUtils.createDialogButton((Composite)parent, (String)UICoreMessages.pref_page_security_secure_storage_button, (SelectionListener)SelectionListener.widgetSelectedAdapter(event -> {
            AdvancedPreferences page = new AdvancedPreferences();
            PreferencePageDialog dialog = new PreferencePageDialog(parent.getShell(), (PreferencePage)page);
            page.getPreferenceStore();
            dialog.open();
        }));
        this.setButtonSize(buttonAdvanced);
    }

    void performDefaults() {
    }

    void performOk() {
        if (this.providerModified) {
            PasswordProviderUtils.setPreferredProvider(this.selectedProvider);
        }
        if (this.providerModified || this.secureStorageToggled) {
            boolean enabled = this.secureStorageCheckbox.getSelection();
            this.saveEnabled(enabled);
            this.updateProjects(enabled ? SecureStoragePreferences::saveAllSecrets : SecureStoragePreferences::resolveAllSecrets);
        }
        if (this.providerModified) {
            PasswordProviderUtils.resetPasswordProviders();
            this.refreshChangePasswordButton();
        }
        this.providerModified = false;
        this.secureStorageToggled = false;
    }

    private void updateProjects(ThrowingConsumer<DBPProject, DBException> projectConsumer) {
        try {
            UIUtils.runInProgressDialog(monitor -> {
                List projects = DBWorkbench.getPlatform().getWorkspace().getProjects();
                monitor.beginTask("Sync project configurations", projects.size());
                for (DBPProject project : projects) {
                    DBPProjectAdvanced advanced;
                    if (project instanceof DBPProjectAdvanced && (advanced = (DBPProjectAdvanced)project).isProjectPasswordUsed()) continue;
                    monitor.subTask("Sync project '" + project.getName() + "'");
                    try {
                        project.ensureOpen();
                        projectConsumer.accept(project);
                    }
                    catch (Exception e) {
                        log.error((Object)("Error synchronizing project '" + project.getName() + "'"), (Throwable)e);
                    }
                    monitor.worked(1);
                }
                monitor.done();
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Projects configuration flush", "Error saving project metadata", (Throwable)e);
        }
    }

    private static void resolveAllSecrets(DBPProject project) throws DBException {
        DBPDataSourceRegistry registry = project.getDataSourceRegistry();
        DBSSecretController secretController = DBSSecretController.getProjectSecretController((DBPProject)project);
        registry.resolveSecrets(secretController);
        if (secretController instanceof DBSSecretBrowser) {
            DBSSecretBrowser browser = (DBSSecretBrowser)secretController;
            browser.clearAllSecrets(project.getId());
        }
        registry.flushConfig();
    }

    private static void saveAllSecrets(DBPProject project) throws DBException {
        DBPDataSourceRegistry registry = project.getDataSourceRegistry();
        DBSSecretController secretController = DBSSecretController.getProjectSecretController((DBPProject)project);
        registry.persistSecrets(secretController);
        registry.flushConfig();
    }

    private boolean isSecureDatabaseCredentials() {
        return DBeaverEnterprisePreferences.getPreferences().getBoolean("security.secure.password.storage", false);
    }

    private boolean isDbeaverPasswordProvider(@Nullable PasswordProviderDescription selectedPasswordProvider) {
        if (selectedPasswordProvider == null) {
            return false;
        }
        return selectedPasswordProvider.getId().equals("com.dbeaver.app.advanced.dbeaverpasswordprovider");
    }

    private void saveEnabled(boolean enabled) {
        IEclipsePreferences store = DBeaverEnterprisePreferences.getPreferences();
        store.putBoolean("security.secure.password.storage", enabled);
        try {
            store.flush();
        }
        catch (BackingStoreException e) {
            log.error((Object)e);
        }
        Path metadataFolder = GeneralUtils.getMetadataFolder();
        Properties props = BaseWorkspaceImpl.readWorkspaceInfo((Path)metadataFolder);
        props.put("security.secure.password.storage", CommonUtils.toString((Object)enabled));
        BaseWorkspaceImpl.writeWorkspaceInfo((Path)metadataFolder, (Properties)props);
    }

    private boolean changePassword(ISecurePreferences node, String moduleID, String name, Shell shell) {
        MessageBox messageBox;
        ReEncrypter reEncrypter = new ReEncrypter(node, moduleID);
        if (!reEncrypter.decrypt()) {
            messageBox = new MessageBox(shell, 200);
            messageBox.setText(SecUIMessages.changePasswordWizardTitle);
            messageBox.setMessage(SecUIMessages.wizardDecodeWarning);
            if (messageBox.open() == 64) {
                return false;
            }
        }
        if (!reEncrypter.switchToNewPassword()) {
            messageBox = new MessageBox(shell, 33);
            messageBox.setText(SecUIMessages.changePasswordWizardTitle);
            messageBox.setMessage(SecUIMessages.wizardSwitchError);
            messageBox.open();
            return false;
        }
        reEncrypter.encrypt();
        String msg = NLS.bind((String)SecUIMessages.passwordChangeDone, (Object)name);
        MessageDialog.openInformation((Shell)StorageUtils.getShell(), (String)SecUIMessages.generalDialogTitle, (String)msg);
        return true;
    }

    private void setButtonSize(Button button) {
        GridDataFactory.defaultsFor((Control)button).align(1, 1).grab(false, false).applyTo((Control)button);
    }

    private static interface ThrowingConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }
}

