/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.internal.preferences;

import com.dbeaver.model.security.truststore.CertDescriptor;
import com.dbeaver.model.security.truststore.LocalTrustStoreController;
import com.dbeaver.model.security.truststore.keystore.KeyStoreDescriptor;
import com.dbeaver.model.security.truststore.keystore.KeyStoreRegistry;
import com.dbeaver.ui.internal.UICoreMessages;
import com.dbeaver.ui.internal.dialogs.ImportCertificateDialog;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomCheckboxCellEditor;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.dialogs.EditTextDialog;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageTrustStore
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private static final Log log = Log.getLog(PrefPageTrustStore.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.truststore";
    public Table table;
    private TableViewer tableViewer;
    private Button viewButton;
    private Button importButton;
    private Button deleteButton;
    private KeyStore activeKeystore = null;
    private final List<Button> trustStoreButtons = new ArrayList<Button>();
    private Button loadExtendedCertsCheck;
    private String activeKeyStoreId = null;
    private static String initialTrustStoreId = null;
    private static final SimpleDateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        super.noDefaultAndApplyButton();
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        Composite buttonComposite = UIUtils.createComposite((Composite)composite, (int)3);
        SelectionAdapter typeSwitcher = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageTrustStore.this.activeKeyStoreId = (String)e.widget.getData();
                PrefPageTrustStore.this.populateTable();
            }
        };
        List keyStoreDescriptors = KeyStoreRegistry.getInstance().getSupportedKeyStores();
        for (KeyStoreDescriptor keyStoreDescriptor : keyStoreDescriptors) {
            Button button = UIUtils.createRadioButton((Composite)buttonComposite, (String)keyStoreDescriptor.getLabel(), (Object)keyStoreDescriptor.getId(), (SelectionListener)typeSwitcher);
            button.setToolTipText(keyStoreDescriptor.getDescription());
            this.trustStoreButtons.add(button);
        }
        this.loadExtendedCertsCheck = UIUtils.createCheckbox((Composite)buttonComposite, (String)"Load extended cloud certificates", (String)"Automatically load extended cloud and database certificates (e.g. global CA for AWS S3)", (boolean)false, (int)3);
        composite.setLayoutData((Object)new GridData(1808));
        this.tableViewer = new TableViewer(composite, 68352);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 500;
        this.tableViewer.getTable().setLayoutData((Object)gd);
        this.table = this.tableViewer.getTable();
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.table.setHeaderVisible(true);
        ViewerColumnController columnsController = new ViewerColumnController("PrefPageTrustStore", (ColumnViewer)this.tableViewer);
        this.createCertificateTableColumn(columnsController, UICoreMessages.pref_page_trust_table_validity, "", CertDescriptor::isValid, true, 16384);
        this.createCertificateTableColumn(columnsController, UICoreMessages.pref_page_trust_table_entry, "", cert -> cert.getCertificate().getSubjectX500Principal().toString(), false, 16384);
        this.createCertificateTableColumn(columnsController, "Alias", "", CertDescriptor::getAlias, false, 16384);
        this.createCertificateTableColumn(columnsController, UICoreMessages.pref_page_trust_table_type, "", CertDescriptor::getType, false, 16384);
        this.createCertificateTableColumn(columnsController, UICoreMessages.pref_page_trust_table_key_size, "", CertDescriptor::getKeySize, false, 0x1000000);
        this.createCertificateTableColumn(columnsController, UICoreMessages.pref_page_trust_table_expiry, "", certDescriptor -> ISO_DATE_FORMAT.format(certDescriptor.getExpiryDate()), false, 16384);
        this.createCertificateTableColumn(columnsController, UICoreMessages.pref_page_trust_table_last_modified, "", certDescriptor -> ISO_DATE_FORMAT.format(certDescriptor.getLastModifiedDate()), false, 16384);
        this.tableViewer.addDoubleClickListener(event -> {
            Object selCert = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (selCert instanceof CertDescriptor) {
                this.showCertificateInfo((CertDescriptor)selCert);
            }
        });
        Composite bottomButtonComposite = new Composite(composite, 131072);
        GridLayout gl = new GridLayout(3, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        bottomButtonComposite.setLayout((Layout)gl);
        this.viewButton = UIUtils.createDialogButton((Composite)bottomButtonComposite, (String)"View", (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.showCertificateInfo((CertDescriptor)this.tableViewer.getStructuredSelection().getFirstElement())));
        this.importButton = UIUtils.createDialogButton((Composite)bottomButtonComposite, (String)UICoreMessages.pref_page_trust_button_import, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportCertificateDialog importCertificateDialog = new ImportCertificateDialog(PrefPageTrustStore.this.getShell());
                if (importCertificateDialog.open() == 0) {
                    String certificate = importCertificateDialog.getCertificate();
                    String alias = importCertificateDialog.getAlias();
                    try {
                        Collection certs = LocalTrustStoreController.INSTANCE.addCertificates(PrefPageTrustStore.this.activeKeyStoreId, PrefPageTrustStore.this.activeKeystore, alias, Path.of(certificate, new String[0]));
                        for (X509Certificate cert : certs) {
                            PrefPageTrustStore.this.updateTableContents(cert);
                        }
                    }
                    catch (DBException ex) {
                        log.error((Object)"Error importing the certificate", (Throwable)ex);
                    }
                }
            }
        });
        this.deleteButton = UIUtils.createDialogButton((Composite)bottomButtonComposite, (String)UICoreMessages.pref_page_trust_button_delete, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean confirmation;
                IStructuredSelection selection = PrefPageTrustStore.this.tableViewer.getStructuredSelection();
                Object selectedObject = selection.getFirstElement();
                if (selectedObject instanceof CertDescriptor && (confirmation = UIUtils.confirmAction((Shell)PrefPageTrustStore.this.getShell(), (String)UICoreMessages.pref_page_trust_dialog_confirm_delete_title, (String)UICoreMessages.pref_page_trust_dialog_confirm_delete_message))) {
                    CertDescriptor descriptor = (CertDescriptor)selectedObject;
                    try {
                        LocalTrustStoreController.INSTANCE.removeCertificate(PrefPageTrustStore.this.activeKeyStoreId, PrefPageTrustStore.this.activeKeystore, descriptor.getAlias());
                    }
                    catch (DBException ex) {
                        log.error((Object)"Error while removing certificate", (Throwable)ex);
                    }
                    PrefPageTrustStore.this.updateTableContents();
                }
            }
        });
        this.tableViewer.addSelectionChangedListener(event -> this.viewButton.setEnabled(!event.getSelection().isEmpty()));
        columnsController.createColumns(false);
        this.loadPreferences();
        return parent;
    }

    private void showCertificateInfo(CertDescriptor selCert) {
        EditTextDialog dialog = new EditTextDialog(this.getShell(), "Certificate information", selCert.getCertificate().toString(), true);
        dialog.setAutoSize(true);
        dialog.open();
    }

    private void populateTable() {
        this.updateButtons(this.activeKeyStoreId);
        try {
            this.activeKeystore = LocalTrustStoreController.INSTANCE.getTrustStoreInstance(this.activeKeyStoreId);
        }
        catch (DBException ex) {
            log.error((Object)"Error populating table", (Throwable)ex);
        }
        this.updateTableContents();
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.table, (boolean)true));
    }

    private void updateButtons(@NotNull String keyStoreId) {
        KeyStoreDescriptor keyStoreDescriptor = KeyStoreRegistry.getInstance().getKeyStoreById(keyStoreId);
        if (keyStoreDescriptor == null) {
            throw new RuntimeException("KeyStoreDescriptor not found for id: " + keyStoreId);
        }
        this.tableViewer.getTable().setEnabled(true);
        this.tableViewer.getControl().redraw();
        this.deleteButton.setEnabled(keyStoreDescriptor.isModifiable());
        this.importButton.setEnabled(keyStoreDescriptor.isModifiable());
        this.viewButton.setEnabled(false);
        UIUtils.setControlVisible((Control)this.loadExtendedCertsCheck, (boolean)true);
        this.loadExtendedCertsCheck.getParent().getParent().layout(true, true);
    }

    private void createCertificateTableColumn(@NotNull ViewerColumnController<?, ?> columnController, @NotNull String name, @Nullable String description, final @NotNull Function<CertDescriptor, Object> getter, final boolean isBooleanColumn, int style) {
        EditingSupport editingSupport = new EditingSupport((ColumnViewer)this.tableViewer){

            protected CellEditor getCellEditor(Object element) {
                if (isBooleanColumn) {
                    return new CustomCheckboxCellEditor((Composite)PrefPageTrustStore.this.tableViewer.getTable());
                }
                return new TextCellEditor((Composite)PrefPageTrustStore.this.tableViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return false;
            }

            protected Object getValue(Object element) {
                return getter.apply((CertDescriptor)element);
            }

            protected void setValue(Object element, Object value) {
            }
        };
        if (!isBooleanColumn) {
            columnController.addColumn(name, description, style, true, true, o -> CommonUtils.toString(getter.apply((CertDescriptor)o)), editingSupport);
        } else {
            columnController.addBooleanColumn(name, description, style, true, true, o -> (Boolean)getter.apply((CertDescriptor)o), editingSupport);
        }
    }

    private void updateTableContents() {
        this.updateTableContents(null);
    }

    private void updateTableContents(X509Certificate selCert) {
        List certs = new ArrayList();
        try {
            certs = LocalTrustStoreController.INSTANCE.getCertificates(this.activeKeystore);
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        this.tableViewer.setInput(certs);
        if (selCert != null) {
            for (CertDescriptor cert : certs) {
                if (!cert.getCertificate().equals(selCert)) continue;
                this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)cert));
                this.tableViewer.reveal((Object)cert);
            }
        }
    }

    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }

    protected void performDefaults() {
        DBPPreferenceStore preferences = DBWorkbench.getPlatform().getPreferenceStore();
        preferences.setToDefault("security.truststore.id");
    }

    protected void loadPreferences() {
        DBPPreferenceStore preferences = DBWorkbench.getPlatform().getPreferenceStore();
        this.activeKeyStoreId = LocalTrustStoreController.INSTANCE.resolveKeyStoreIdFromPreferenceStore(preferences);
        for (Button trustStoreButton : this.trustStoreButtons) {
            if (!this.activeKeyStoreId.equals(trustStoreButton.getData())) continue;
            trustStoreButton.setSelection(true);
        }
        this.loadExtendedCertsCheck.setSelection(preferences.getBoolean("security.truststore.load.extended.ca"));
        if (initialTrustStoreId == null) {
            initialTrustStoreId = this.activeKeyStoreId;
        }
        this.populateTable();
    }

    public boolean performOk() {
        DBPPreferenceStore preferences = DBWorkbench.getPlatform().getPreferenceStore();
        preferences.setValue("security.truststore.id", this.activeKeyStoreId);
        preferences.setValue("security.truststore.load.extended.ca", this.loadExtendedCertsCheck.getSelection());
        if (!initialTrustStoreId.equals(this.activeKeyStoreId) && UIUtils.confirmAction((Shell)this.getShell(), (String)NLS.bind((String)UICoreMessages.pref_page_trust_dialog_restart_title, (Object)GeneralUtils.getProductName()), (String)NLS.bind((String)UICoreMessages.pref_page_trust_dialog_restart_message, (Object)GeneralUtils.getProductName()))) {
            this.restartWorkbenchOnPrefChange();
        }
        return super.performOk();
    }
}

