/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.internal.panel;

import com.dbeaver.model.document.data.DBCDocumentHierarchical;
import com.dbeaver.ui.internal.UICoreMessages;
import com.dbeaver.ui.internal.editors.EntityEditorInput;
import com.dbeaver.ui.internal.editors.ObjectDataEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.features.DBRFeature;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.DataEditorFeatures;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.UIWidgets;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPanel;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.panel.ResultSetPanelBase;
import org.jkiss.dbeaver.ui.controls.resultset.panel.ResultSetPanelRefresher;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.navigator.itemlist.DatabaseObjectListControl;
import org.jkiss.dbeaver.ui.navigator.itemlist.ObjectListControl;
import org.jkiss.utils.CommonUtils;

public class SubCollectionsPanel
extends ResultSetPanelBase {
    private static final Log log = Log.getLog(SubCollectionsPanel.class);
    public static final String PANEL_ID = "subcollections_panel";
    private final List<DBSObject> subCollectionsList = new ArrayList<DBSObject>();
    private final DBRFeature resultSetPanelSubCollection = DBRFeature.createFeature((DBRFeature)DataEditorFeatures.CATEGORY_RESULT_SET_VIEWER, (String)"Use SubCollection panel");
    private IResultSetPresentation presentation;
    private SubEntitiesTable subcollectionsTable;
    private ResultSetRow currentPanelRow = null;
    private Text filterTextBox;
    private Action addAction;
    private Action deleteAction;
    private Action refreshAction;

    public void contributeActions(IContributionManager manager) {
        this.addAction = new Action("Create collection", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ADD)){

            public void run() {
                Object object;
                if (SubCollectionsPanel.this.currentPanelRow == null) {
                    return;
                }
                final String colName = EnterNameDialog.chooseName((Shell)UIUtils.getActiveWorkbenchShell(), (String)UICoreMessages.panel_subcollections_create_subcollection);
                Object[] values = SubCollectionsPanel.this.currentPanelRow.getValues();
                if (colName == null) {
                    return;
                }
                if (values.length == 1 && (object = values[0]) instanceof DBCDocumentHierarchical) {
                    final DBCDocumentHierarchical dbcDocumentHierarchical = (DBCDocumentHierarchical)object;
                    new AbstractJob("Add Collection"){

                        protected IStatus run(DBRProgressMonitor monitor) {
                            try {
                                dbcDocumentHierarchical.createChildEntity(colName, monitor);
                                UIUtils.syncExec(() -> SubCollectionsPanel.this.refresh(false));
                                return Status.OK_STATUS;
                            }
                            catch (DBCException e) {
                                log.error((Object)"Error adding collection", (Throwable)e);
                                return new Status(4, "org.jkiss.dbeaver.model", e.getMessage());
                            }
                        }
                    }.schedule();
                }
            }
        };
        manager.add((IAction)this.addAction);
        this.deleteAction = new Action("Delete collection", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.DELETE)){

            public void run() {
                SubCollectionsPanel.this.deleteSubCollection();
            }
        };
        manager.add((IAction)this.deleteAction);
        this.refreshAction = new Action("Refresh", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.REFRESH)){

            public void run() {
                SubCollectionsPanel.this.refresh(true);
            }
        };
        manager.add((IAction)this.refreshAction);
    }

    private void deleteSubCollection() {
        Object object;
        ISelection selection = this.subcollectionsTable.getSelectionProvider().getSelection();
        if (selection == null) {
            return;
        }
        Object[] values = this.currentPanelRow.getValues();
        if (values.length == 1 && (object = values[0]) instanceof DBCDocumentHierarchical) {
            DBSEntity entity;
            IStructuredSelection structuredSelection;
            Object firstElement;
            final DBCDocumentHierarchical dbcDocumentHierarchical = (DBCDocumentHierarchical)object;
            if (selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof DBSEntity && UIUtils.confirmAction((String)"Confirm Sub Collection Deletion", (String)("Are you sure you want to delete '" + (entity = (DBSEntity)firstElement).getName() + "' collection"))) {
                new AbstractJob("Deleting Collection"){

                    protected IStatus run(DBRProgressMonitor monitor) {
                        try {
                            dbcDocumentHierarchical.deleteChildEntity(entity.getName(), monitor);
                            UIUtils.syncExec(() -> SubCollectionsPanel.this.refresh(false));
                            return Status.OK_STATUS;
                        }
                        catch (DBCException e) {
                            log.error((Object)"Error adding collection", (Throwable)e);
                            return new Status(4, "org.jkiss.dbeaver.model", e.getMessage());
                        }
                    }
                }.schedule();
            }
        }
    }

    public Control createContents(IResultSetPresentation presentation, Composite parent) {
        this.presentation = presentation;
        this.currentPanelRow = presentation.getController().getCurrentRow();
        Composite subCollectionPlaceholder = UIUtils.createComposite((Composite)parent, (int)1);
        subCollectionPlaceholder.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        Composite filterPanel = UIUtils.createComposite((Composite)subCollectionPlaceholder, (int)2);
        filterPanel.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)filterPanel, (String)UICoreMessages.panel_subcollections_filter_label);
        this.filterTextBox = new Text(filterPanel, 2432);
        this.filterTextBox.setLayoutData((Object)new GridData(768));
        this.filterTextBox.addModifyListener(e -> this.refresh(false));
        this.filterTextBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    SubCollectionsPanel.this.filterTextBox.setText("");
                }
            }
        });
        this.subcollectionsTable = new SubEntitiesTable(subCollectionPlaceholder);
        this.subcollectionsTable.setLayoutData(new GridData(1808));
        this.subcollectionsTable.setFitWidth(true);
        this.subcollectionsTable.setToolTipText(UICoreMessages.panel_subcollections_table_info);
        this.subcollectionsTable.setInfo(UICoreMessages.panel_subcollections_table_info);
        this.subcollectionsTable.setShowDivider(true);
        this.subcollectionsTable.getItemsViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    SubCollectionsPanel.this.deleteSubCollection();
                }
                super.keyPressed(e);
            }
        });
        this.subcollectionsTable.setDoubleClickHandler(event -> {
            IStructuredSelection structuredSelection;
            Object firstElement;
            ISelection selection = this.subcollectionsTable.getSelectionProvider().getSelection();
            if (selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof DBSEntity) {
                DBSEntity entity = (DBSEntity)firstElement;
                EntityEditorInput entityEditorInput = new EntityEditorInput((DBSObject)entity, null);
                IWorkbenchWindow activeWorkbenchWindow = UIUtils.getActiveWorkbenchWindow();
                try {
                    activeWorkbenchWindow.getActivePage().openEditor((IEditorInput)entityEditorInput, ObjectDataEditor.class.getName());
                }
                catch (PartInitException e) {
                    log.error((Object)"Error activating editor", (Throwable)e);
                }
            }
        });
        this.subcollectionsTable.getSelectionProvider().addSelectionChangedListener(event -> this.deleteAction.setEnabled(this.rowCanContainSubCollections() && !this.subcollectionsTable.getSelectionProvider().getSelection().isEmpty()));
        if (this.presentation instanceof ISelectionProvider) {
            ISelectionChangedListener listener = event -> {
                if (this.presentation.getController().getVisiblePanel() == this) {
                    ResultSetRow row = presentation.getController().getCurrentRow();
                    if (row != null && row != this.currentPanelRow) {
                        this.currentPanelRow = row;
                        this.refresh(false);
                    }
                    this.addAction.setEnabled(this.rowCanContainSubCollections());
                    this.deleteAction.setEnabled(this.rowCanContainSubCollections() && !this.subcollectionsTable.getSelectionProvider().getSelection().isEmpty());
                }
            };
            ((ISelectionProvider)this.presentation).addSelectionChangedListener(listener);
            presentation.getControl().addDisposeListener(e -> ((ISelectionProvider)presentation).removeSelectionChangedListener(listener));
        }
        ResultSetPanelRefresher.installOn((IResultSetPanel)this, (IResultSetPresentation)presentation);
        this.resultSetPanelSubCollection.use();
        return subCollectionPlaceholder;
    }

    private boolean rowCanContainSubCollections() {
        return this.currentPanelRow != null && this.currentPanelRow.getState() != 2;
    }

    public boolean isDirty() {
        return false;
    }

    public void activatePanel() {
        this.refresh(false);
    }

    public void deactivatePanel() {
    }

    public void setFocus() {
        this.subcollectionsTable.setFocus();
    }

    public void refresh(boolean force) {
        DBCExecutionContext executionContext;
        if (force && (executionContext = this.presentation.getController().getExecutionContext()) != null) {
            DBUtils.fireObjectRefresh((DBSObject)executionContext.getDataSource());
        }
        this.subCollectionsList.clear();
        if (this.subcollectionsTable.isLoading()) {
            return;
        }
        this.subcollectionsTable.clearListData();
        this.subcollectionsTable.refreshActions();
        this.subcollectionsTable.loadData();
    }

    private class LoadSubCollectionsService
    extends DatabaseLoadService<Collection<DBSObject>> {
        List<? extends DBSEntity> collections;

        LoadSubCollectionsService() {
            super("Load Collections", SubCollectionsPanel.this.presentation.getController().getExecutionContext());
        }

        public Collection<DBSObject> evaluate(@NotNull DBRProgressMonitor monitor) throws InvocationTargetException {
            if (SubCollectionsPanel.this.presentation instanceof ISelectionProvider) {
                try {
                    DBCExecutionContext executionContext = SubCollectionsPanel.this.presentation.getController().getExecutionContext();
                    if (executionContext == null) {
                        throw new DBException("No execution context");
                    }
                    if (SubCollectionsPanel.this.currentPanelRow != null && SubCollectionsPanel.this.currentPanelRow.getState() != 2) {
                        DBDDocument document;
                        Object object;
                        Object[] values = SubCollectionsPanel.this.currentPanelRow.getValues();
                        if (values.length == 1 && (object = values[0]) instanceof DBDDocument && (document = (DBDDocument)object) instanceof DBCDocumentHierarchical) {
                            DBCDocumentHierarchical hierarchical = (DBCDocumentHierarchical)document;
                            DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)executionContext.getDataSource(), param -> {
                                List list = this.collections = hierarchical.listChildrenEntities(monitor);
                            });
                            UIUtils.syncExec(() -> {
                                if (SubCollectionsPanel.this.filterTextBox != null && !SubCollectionsPanel.this.filterTextBox.isDisposed() && !CommonUtils.isEmpty((String)SubCollectionsPanel.this.filterTextBox.getText())) {
                                    SubCollectionsPanel.this.subCollectionsList.addAll(this.collections.stream().filter(it -> it.getName().contains(SubCollectionsPanel.this.filterTextBox.getText())).toList());
                                } else {
                                    SubCollectionsPanel.this.subCollectionsList.addAll(this.collections);
                                }
                            });
                        }
                        if (SubCollectionsPanel.this.subCollectionsList.isEmpty() && SubCollectionsPanel.this.deleteAction != null) {
                            SubCollectionsPanel.this.deleteAction.setEnabled(false);
                        }
                        return SubCollectionsPanel.this.subCollectionsList;
                    }
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e, "Error loading collections");
                }
            }
            return SubCollectionsPanel.this.subCollectionsList;
        }
    }

    private class SubEntitiesTable
    extends DatabaseObjectListControl<DBSObject> {
        SubEntitiesTable(Composite parent) {
            super(parent, 0x10000800, (IWorkbenchSite)SubCollectionsPanel.this.presentation.getController().getSite(), (IContentProvider)new TreeContentProvider(){

                public Object[] getChildren(Object parentElement) {
                    return new Object[0];
                }

                public boolean hasChildren(Object element) {
                    return false;
                }
            });
        }

        public void fillCustomActions(IContributionManager contributionManager) {
            contributionManager.add((IContributionItem)new Separator());
            contributionManager.add((IAction)SubCollectionsPanel.this.addAction);
            contributionManager.add((IAction)SubCollectionsPanel.this.deleteAction);
            contributionManager.add((IAction)SubCollectionsPanel.this.refreshAction);
            contributionManager.add((IContributionItem)new Separator());
            UIWidgets.fillDefaultTreeContextMenu((IContributionManager)contributionManager, (Tree)((Tree)this.getItemsViewer().getControl()));
        }

        @NotNull
        protected String getListConfigId(List<Class<?>> classList) {
            DBCExecutionContext executionContext = SubCollectionsPanel.this.presentation.getController().getExecutionContext();
            if (executionContext == null) {
                return "SubEntities";
            }
            return "SubEntities/" + executionContext.getDataSource().getContainer().getDriver().getId();
        }

        @Nullable
        protected DBPImage getObjectImage(DBSObject item) {
            return DBIcon.TREE_TABLE;
        }

        protected LoadingJob<Collection<DBSObject>> createLoadService(boolean forUpdate) {
            return LoadingJob.createService((ILoadService)new LoadSubCollectionsService(), (ILoadVisualizer)new ObjectListControl.ObjectsLoadVisualizer((ObjectListControl)this){

                public void completeLoading(Collection<DBSObject> items) {
                    super.completeLoading(items);
                    TreeViewer itemsViewer = (TreeViewer)((SubEntitiesTable)SubEntitiesTable.this).SubCollectionsPanel.this.subcollectionsTable.getItemsViewer();
                    if (!itemsViewer.getControl().isDisposed()) {
                        itemsViewer.expandToLevel(2);
                    }
                }
            });
        }
    }
}

