/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.connections.proxy;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.registry.configurator.DBPConnectionEditIntention;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.net.SocksProxyConfiguratorUI;

public class AdvancedProxyConfiguratorUI
extends SocksProxyConfiguratorUI {
    private Button useProxyCheck;
    private Button stratBrowserCheck;
    private Button stratOSCheck;
    private Button stratEnvCheck;

    public void createControl(@NotNull Composite parent, Object object, @NotNull Runnable propertyChangeListener) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(1808));
        Group dynamicGroup = UIUtils.createControlGroup((Composite)composite, (String)"Automatic proxy configuration", (int)2, (int)768, (int)-1);
        this.useProxyCheck = UIUtils.createCheckbox((Composite)dynamicGroup, (String)"Use automatic proxy detection:", (String)"Use automatic proxy configuration (PAC)", (boolean)false, (int)2);
        Control el = UIUtils.createEmptyLabel((Composite)dynamicGroup, (int)1, (int)1);
        GridData gd = new GridData();
        gd.widthHint = 20;
        el.setLayoutData((Object)gd);
        this.stratBrowserCheck = UIUtils.createCheckbox((Composite)dynamicGroup, (String)"Use browser proxy settings", (String)"Use web browser proxy settings", (boolean)false, (int)1);
        UIUtils.createEmptyLabel((Composite)dynamicGroup, (int)1, (int)1);
        this.stratOSCheck = UIUtils.createCheckbox((Composite)dynamicGroup, (String)"Use OS settings", (String)"Use proxy settings from operation system", (boolean)false, (int)1);
        UIUtils.createEmptyLabel((Composite)dynamicGroup, (int)1, (int)1);
        this.stratEnvCheck = UIUtils.createCheckbox((Composite)dynamicGroup, (String)"Use environment variables", (String)"Use proxy settings from environment variables", (boolean)false, (int)1);
        if (this.getEditIntention() == DBPConnectionEditIntention.CREDENTIALS_ONLY) {
            this.useProxyCheck.setEnabled(false);
            this.stratBrowserCheck.setEnabled(false);
            this.stratOSCheck.setEnabled(false);
            this.stratEnvCheck.setEnabled(false);
        }
        super.createSocksGroup(composite);
    }

    public void loadSettings(@NotNull DBWHandlerConfiguration configuration) {
        this.useProxyCheck.setSelection(configuration.getBooleanProperty("pac_enabled"));
        this.stratOSCheck.setSelection(configuration.getBooleanProperty("pac_strategy_os"));
        this.stratBrowserCheck.setSelection(configuration.getBooleanProperty("pac_strategy_browser"));
        this.stratEnvCheck.setSelection(configuration.getBooleanProperty("pac_strategy_env"));
        super.loadSettings(configuration);
    }

    public void saveSettings(@NotNull DBWHandlerConfiguration configuration) {
        super.saveSettings(configuration);
        configuration.setProperty("pac_enabled", (Object)this.useProxyCheck.getSelection());
        configuration.setProperty("pac_strategy_os", (Object)this.stratOSCheck.getSelection());
        configuration.setProperty("pac_strategy_browser", (Object)this.stratBrowserCheck.getSelection());
        configuration.setProperty("pac_strategy_env", (Object)this.stratEnvCheck.getSelection());
    }

    public void resetSettings(@NotNull DBWHandlerConfiguration configuration) {
        super.resetSettings(configuration);
    }
}

