/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.CorePublisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

@Stability.Internal
public interface ReactorOps {
    default public <T> Mono<T> publishOnUserScheduler(Supplier<CompletableFuture<T>> future) {
        return this.publishOnUserScheduler(Reactor.toMono(future));
    }

    public <T> Mono<T> publishOnUserScheduler(Mono<T> var1);

    public <T> Flux<T> publishOnUserScheduler(Flux<T> var1);

    @Stability.Internal
    public static <T> T proxyToPublishOnSuppliedScheduler(final T obj, Class<T> interfaceToProxy, final @Nullable Supplier<Scheduler> scheduler) {
        if (scheduler == null) {
            return obj;
        }
        return interfaceToProxy.cast(Proxy.newProxyInstance(interfaceToProxy.getClassLoader(), new Class[]{interfaceToProxy}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    Object result = method.invoke(obj, args);
                    if (result instanceof CorePublisher) {
                        if (result instanceof Mono) {
                            return Mono.defer(() -> 1.lambda$invoke$0(result, (Supplier)scheduler));
                        }
                        if (result instanceof Flux) {
                            return Flux.defer(() -> 1.lambda$invoke$1(result, (Supplier)scheduler));
                        }
                    }
                    return result;
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }

            private static /* synthetic */ Publisher lambda$invoke$1(Object result, Supplier scheduler2) {
                return ((Flux)result).publishOn((Scheduler)scheduler2.get());
            }

            private static /* synthetic */ Mono lambda$invoke$0(Object result, Supplier scheduler2) {
                return ((Mono)result).publishOn((Scheduler)scheduler2.get());
            }
        }));
    }
}

