/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.retry;

import com.couchbase.client.core.annotation.Stability;
import java.time.Duration;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

@Stability.Internal
public class ProtostellarRequestBehaviour {
    private final @Nullable Duration retryDuration;
    private final @Nullable RuntimeException exception;

    private ProtostellarRequestBehaviour(@Nullable Duration retryDuration, @Nullable RuntimeException exception) {
        this.retryDuration = retryDuration;
        this.exception = exception;
    }

    public static ProtostellarRequestBehaviour retry(Duration retryDuration) {
        Objects.requireNonNull(retryDuration);
        return new ProtostellarRequestBehaviour(retryDuration, null);
    }

    public static ProtostellarRequestBehaviour fail(RuntimeException err) {
        Objects.requireNonNull(err);
        return new ProtostellarRequestBehaviour(null, err);
    }

    public static ProtostellarRequestBehaviour success() {
        return new ProtostellarRequestBehaviour(null, null);
    }

    public @Nullable Duration retryDuration() {
        return this.retryDuration;
    }

    public @Nullable RuntimeException exception() {
        return this.exception;
    }
}

