/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.json.stream;

import com.couchbase.client.core.json.stream.MatchedValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

class PathTree {
    private String jsonPointer;
    private @Nullable Consumer<MatchedValue> callback = null;
    private final Map<String, PathTree> children = new HashMap<String, PathTree>();
    private final String name;
    private final @Nullable PathTree parent;

    private PathTree(@Nullable PathTree parent, String name) {
        this.parent = parent;
        this.name = Objects.requireNonNull(name);
    }

    static PathTree createRoot() {
        return new PathTree(null, "$ROOT");
    }

    @Nullable Consumer<MatchedValue> callback() {
        return this.callback;
    }

    String jsonPointer() {
        return this.jsonPointer;
    }

    @Nullable PathTree parent() {
        return this.parent;
    }

    @Nullable PathTree subtree(String name) {
        return this.children.get(name);
    }

    private PathTree getOrCreateSubtree(String name) {
        return this.children.computeIfAbsent(name, ignoreKey -> new PathTree(this, name));
    }

    static List<String> parseJsonPointer(String jsonPointer) {
        if (!jsonPointer.startsWith("/") && !jsonPointer.isEmpty()) {
            throw new IllegalArgumentException("JSON pointer must be empty or start with forward slash (/) but got \"" + jsonPointer + "\"");
        }
        int HONOR_ALL_DELIMITERS = -1;
        return Arrays.stream(jsonPointer.split("/", -1)).map(s -> s.replace("~1", "/").replace("~0", "~")).collect(Collectors.toList());
    }

    void add(String jsonPointer, Consumer<MatchedValue> callback) {
        this.add(PathTree.parseJsonPointer(jsonPointer), jsonPointer, callback);
    }

    private void add(List<String> path, String jsonPointer, Consumer<MatchedValue> callback) {
        Objects.requireNonNull(callback);
        Objects.requireNonNull(jsonPointer);
        PathTree tree = this;
        for (String p : path) {
            tree = tree.getOrCreateSubtree(p);
            if (tree.callback == null) continue;
            throw new IllegalStateException("Already have a callback for path " + path + " or one of its ancestors.");
        }
        if (!tree.children.isEmpty()) {
            throw new IllegalStateException("Already have a callback for a descendant of path " + path);
        }
        tree.jsonPointer = jsonPointer;
        tree.callback = callback;
    }

    public String toString() {
        return "\"" + this.name + "\"" + (this.children.isEmpty() ? "!" : ":" + this.children.values());
    }
}

