/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.org.xbill.DNS;

import com.couchbase.client.core.deps.org.xbill.DNS.Message;
import com.couchbase.client.core.deps.org.xbill.DNS.NioClient;
import com.couchbase.client.core.deps.org.xbill.DNS.io.UdpIoClient;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NioUdpClient
extends NioClient
implements UdpIoClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NioUdpClient.class);
    private final int ephemeralStart;
    private final int ephemeralRange;
    private final SecureRandom prng;
    private final Queue<Transaction> registrationQueue = new ConcurrentLinkedQueue<Transaction>();
    private final Queue<Transaction> pendingTransactions = new ConcurrentLinkedQueue<Transaction>();

    NioUdpClient() {
        int ephemeralStartDefault = 49152;
        int ephemeralEndDefault = 65535;
        if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            ephemeralStartDefault = 32768;
            ephemeralEndDefault = 60999;
        }
        this.ephemeralStart = Integer.getInteger("dnsjava.udp.ephemeral.start", ephemeralStartDefault);
        int ephemeralEnd = Integer.getInteger("dnsjava.udp.ephemeral.end", ephemeralEndDefault);
        this.ephemeralRange = ephemeralEnd - this.ephemeralStart;
        this.prng = Boolean.getBoolean("dnsjava.udp.ephemeral.use_ephemeral_port") ? null : new SecureRandom();
        NioUdpClient.setRegistrationsTask(this::processPendingRegistrations, false);
        NioUdpClient.setTimeoutTask(this::checkTransactionTimeouts, false);
        NioUdpClient.setCloseTask(this::closeUdp, false);
    }

    private void processPendingRegistrations() {
        while (!this.registrationQueue.isEmpty()) {
            Transaction t = this.registrationQueue.poll();
            if (t == null) continue;
            try {
                log.trace("Registering OP_READ for transaction with id {}", (Object)t.id);
                t.channel.register(NioUdpClient.selector(), 1, t);
                t.send();
            }
            catch (IOException e) {
                t.completeExceptionally(e);
            }
        }
    }

    private void checkTransactionTimeouts() {
        Iterator it = this.pendingTransactions.iterator();
        while (it.hasNext()) {
            Transaction t = (Transaction)it.next();
            if (t.endTime - System.nanoTime() >= 0L) continue;
            t.completeExceptionally(new SocketTimeoutException("Query timed out"));
            it.remove();
        }
    }

    @Override
    public CompletableFuture<byte[]> sendAndReceiveUdp(InetSocketAddress local, InetSocketAddress remote, Message query, byte[] data, int max, Duration timeout) {
        long endTime = System.nanoTime() + timeout.toNanos();
        CompletableFuture<byte[]> f = new CompletableFuture<byte[]>();
        DatagramChannel channel = null;
        try {
            Selector selector = NioUdpClient.selector();
            channel = DatagramChannel.open();
            channel.configureBlocking(false);
            Transaction t = new Transaction(query.getHeader().getID(), data, max, endTime, channel, f);
            if (local == null || local.getPort() == 0) {
                boolean bound = false;
                for (int i = 0; i < 1024; ++i) {
                    try {
                        InetSocketAddress addr = null;
                        if (local == null) {
                            if (this.prng != null) {
                                addr = new InetSocketAddress(this.prng.nextInt(this.ephemeralRange) + this.ephemeralStart);
                            }
                        } else {
                            int port = local.getPort();
                            if (port == 0 && this.prng != null) {
                                port = this.prng.nextInt(this.ephemeralRange) + this.ephemeralStart;
                            }
                            addr = new InetSocketAddress(local.getAddress(), port);
                        }
                        channel.bind(addr);
                        bound = true;
                        break;
                    }
                    catch (SocketException socketException) {
                        continue;
                    }
                }
                if (!bound) {
                    t.completeExceptionally(new IOException("No available source port found"));
                    return f;
                }
            }
            channel.connect(remote);
            this.pendingTransactions.add(t);
            this.registrationQueue.add(t);
            selector.wakeup();
        }
        catch (IOException e) {
            NioUdpClient.silentCloseChannel(channel);
            f.completeExceptionally(e);
        }
        catch (Throwable e) {
            NioUdpClient.silentCloseChannel(channel);
            throw e;
        }
        return f;
    }

    private static void silentCloseChannel(DatagramChannel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void closeUdp() {
        this.registrationQueue.clear();
        EOFException closing = new EOFException("Client is closing");
        this.pendingTransactions.forEach(t -> ((Transaction)t).completeExceptionally(closing));
        this.pendingTransactions.clear();
    }

    private class Transaction
    implements NioClient.KeyProcessor {
        private final int id;
        private final byte[] data;
        private final int max;
        private final long endTime;
        private final DatagramChannel channel;
        private final CompletableFuture<byte[]> f;

        void send() throws IOException {
            ByteBuffer buffer = ByteBuffer.wrap(this.data);
            NioClient.verboseLog("UDP write: transaction id=" + this.id, this.channel.socket().getLocalSocketAddress(), this.channel.socket().getRemoteSocketAddress(), this.data);
            int n = this.channel.send(buffer, this.channel.socket().getRemoteSocketAddress());
            if (n == 0) {
                throw new EOFException("Insufficient room for the datagram in the underlying output buffer for transaction " + this.id);
            }
            if (n < this.data.length) {
                throw new EOFException("Could not send all data for transaction " + this.id);
            }
        }

        @Override
        public void processReadyKey(SelectionKey key) {
            int read;
            if (!key.isReadable()) {
                this.completeExceptionally(new EOFException("Key for transaction " + this.id + " is not readable"));
                NioUdpClient.this.pendingTransactions.remove(this);
                return;
            }
            DatagramChannel keyChannel = (DatagramChannel)key.channel();
            ByteBuffer buffer = ByteBuffer.allocate(this.max);
            try {
                read = keyChannel.read(buffer);
                if (read <= 0) {
                    throw new EOFException();
                }
            }
            catch (IOException e) {
                this.completeExceptionally(e);
                NioUdpClient.this.pendingTransactions.remove(this);
                return;
            }
            buffer.flip();
            byte[] resultingData = new byte[read];
            System.arraycopy(buffer.array(), 0, resultingData, 0, read);
            NioClient.verboseLog("UDP read: transaction id=" + this.id, keyChannel.socket().getLocalSocketAddress(), keyChannel.socket().getRemoteSocketAddress(), resultingData);
            this.silentDisconnectAndCloseChannel();
            this.f.complete(resultingData);
            NioUdpClient.this.pendingTransactions.remove(this);
        }

        private void completeExceptionally(Exception e) {
            this.silentDisconnectAndCloseChannel();
            this.f.completeExceptionally(e);
        }

        private void silentDisconnectAndCloseChannel() {
            try {
                this.channel.disconnect();
            }
            catch (IOException iOException) {
            }
            finally {
                NioUdpClient.silentCloseChannel(this.channel);
            }
        }

        @Generated
        public Transaction(int id, byte[] data, int max, long endTime, DatagramChannel channel, CompletableFuture<byte[]> f) {
            this.id = id;
            this.data = data;
            this.max = max;
            this.endTime = endTime;
            this.channel = channel;
            this.f = f;
        }
    }
}

