/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.apptelemetry.reporter;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.apptelemetry.collector.AppTelemetryCollector;
import com.couchbase.client.core.cnc.apptelemetry.reporter.AppTelemetryReporter;
import com.couchbase.client.core.cnc.apptelemetry.reporter.AppTelemetryWebSocketClient;
import com.couchbase.client.core.cnc.apptelemetry.reporter.BackoffCalculator;
import com.couchbase.client.core.env.CouchbaseThreadFactory;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.util.CbCollections;
import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stability.Internal
public class AppTelemetryReporterImpl
implements AppTelemetryReporter {
    private static final Logger log = LoggerFactory.getLogger(AppTelemetryReporterImpl.class);
    private static final ThreadFactory threadFactory = new CouchbaseThreadFactory("app-telemetry-reporter-");
    private static final BackoffCalculator backoffCalculator = new BackoffCalculator(Duration.ofMillis(100L), Duration.ofHours(1L));
    private final AtomicLong connectionAttempt = new AtomicLong();
    private final AppTelemetryCollector collector;
    private final Thread thread;
    private volatile boolean done;
    private Set<URI> remotes = Collections.emptySet();
    private @Nullable URI selectedRemote;
    private static final Random random = new Random();

    public AppTelemetryReporterImpl(CoreContext ctx, AppTelemetryCollector collector) {
        this.collector = Objects.requireNonNull(collector);
        AppTelemetryWebSocketClient webSocketClient = new AppTelemetryWebSocketClient(ctx, collector);
        this.thread = threadFactory.newThread(() -> {
            try {
                while (!this.done) {
                    try {
                        this.sleepForBackoff(this.connectionAttempt.getAndIncrement());
                        URI remote = this.selectRemote();
                        if (remote == null) {
                            AppTelemetryReporterImpl.sleepUntilInterrupted();
                            throw new RuntimeException("unreachable");
                        }
                        webSocketClient.connectAndWaitForClose(remote, this::resetBackoff);
                        log.info("App telemetry connection closed by peer; recalibrating!");
                    }
                    catch (InterruptedException e) {
                        this.resetBackoff();
                        log.info("App telemetry reporter interrupted; recalibrating!");
                    }
                    catch (Exception e) {
                        log.info("App telemetry connection failed; recalibrating!", (Throwable)e);
                    }
                }
            }
            finally {
                log.info("App telemetry reporter thread finished.");
            }
        });
        this.thread.start();
    }

    private void resetBackoff() {
        this.connectionAttempt.set(0L);
    }

    private static void sleepUntilInterrupted() throws InterruptedException {
        Thread.sleep(Long.MAX_VALUE);
    }

    private void sleepForBackoff(long attempt) throws InterruptedException {
        Duration delay = backoffCalculator.delayForAttempt(attempt);
        log.debug("App telemetry reporter connection attempt {} sleeping for backoff: {}", (Object)attempt, (Object)delay);
        TimeUnit.MILLISECONDS.sleep(delay.toMillis());
    }

    private synchronized @Nullable URI selectRemote() {
        this.selectedRemote = AppTelemetryReporterImpl.randomOrNull(this.remotes);
        if (this.selectedRemote == null) {
            log.info("App telemetry reporter has no remotes available.");
        } else {
            log.info("Selected remote for app telemetry: {}", (Object)RedactableArgument.redactSystem(this.selectedRemote));
        }
        return this.selectedRemote;
    }

    @Override
    public synchronized void updateRemotes(Set<URI> updatedRemotes) {
        this.collector.setPaused(this.done || updatedRemotes.isEmpty());
        if (this.done || updatedRemotes.equals(this.remotes)) {
            return;
        }
        this.remotes = CbCollections.setCopyOf(updatedRemotes);
        if (this.selectedRemote == null && !this.remotes.isEmpty()) {
            this.interruptWorker("a remote host is now available");
        } else if (this.selectedRemote != null && !this.remotes.contains(this.selectedRemote)) {
            this.selectedRemote = null;
            this.interruptWorker("the previously selected remote host no longer wants to receive telemetry");
        }
    }

    @Override
    public synchronized void close() {
        if (!this.done) {
            this.done = true;
            this.interruptWorker("the reporter is shutting down");
        }
    }

    private void interruptWorker(String reason) {
        log.info("Interrupting the app telemetry reporter thread because {}", (Object)reason);
        this.thread.interrupt();
    }

    private static <T> @Nullable T randomOrNull(Collection<T> items) {
        if (items.isEmpty()) {
            return null;
        }
        int index = random.nextInt(items.size());
        if (items instanceof List) {
            return (T)((List)items).get(index);
        }
        Iterator<T> iterator = items.iterator();
        for (int i = 0; i < index; ++i) {
            iterator.next();
        }
        return iterator.next();
    }
}

