/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.classic.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.query.CoreQueryMetaData;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.classic.query.ClassicCoreQueryMetaData;
import com.couchbase.client.core.msg.query.QueryChunkHeader;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.msg.query.QueryChunkTrailer;
import com.couchbase.client.core.topology.NodeIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

@Stability.Internal
public class ClassicCoreQueryResult
extends CoreQueryResult {
    private final List<QueryChunkRow> rows;
    private final QueryChunkHeader header;
    private final QueryChunkTrailer trailer;
    private final NodeIdentifier lastDispatchedToNode;

    public ClassicCoreQueryResult(QueryChunkHeader header, List<QueryChunkRow> rows, QueryChunkTrailer trailer, NodeIdentifier lastDispatchedToNode) {
        this.rows = rows;
        this.header = header;
        this.trailer = trailer;
        this.lastDispatchedToNode = lastDispatchedToNode;
    }

    @Override
    public Stream<QueryChunkRow> rows() {
        return this.rows.stream();
    }

    @Override
    public List<QueryChunkRow> collectRows() {
        return new ArrayList<QueryChunkRow>(this.rows);
    }

    @Override
    public CoreQueryMetaData metaData() {
        return ClassicCoreQueryMetaData.from(this.header, this.trailer);
    }

    @Override
    public NodeIdentifier lastDispatchedTo() {
        return this.lastDispatchedToNode;
    }
}

