/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.classic.manager;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.config.BucketType;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.manager.bucket.CoreBucketSettings;
import com.couchbase.client.core.manager.bucket.CoreCompressionMode;
import com.couchbase.client.core.manager.bucket.CoreConflictResolutionType;
import com.couchbase.client.core.manager.bucket.CoreEvictionPolicyType;
import com.couchbase.client.core.manager.bucket.CoreStorageBackend;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import java.time.Duration;
import java.util.Map;
import reactor.util.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CoreBucketSettingsJson
implements CoreBucketSettings {
    private final String name;
    private final Boolean flushEnabled;
    private final long ramQuotaMB;
    private final int numReplicas;
    @Nullable
    private final Boolean replicaIndexes;
    @Nullable
    private final Duration maxExpiry;
    @Nullable
    private final CoreCompressionMode compressionMode;
    @Nullable
    private final BucketType bucketType;
    @Nullable
    private final CoreConflictResolutionType conflictResolutionType;
    @Nullable
    private final CoreEvictionPolicyType evictionPolicy;
    @Nullable
    private final DurabilityLevel minimumDurabilityLevel;
    @Nullable
    private final CoreStorageBackend storageBackend;
    @Nullable
    private final Boolean historyRetentionCollectionDefault;
    @Nullable
    private final Long historyRetentionBytes;
    @Nullable
    private final Duration historyRetentionDuration;
    @Nullable
    private final Integer numVBuckets;

    @Stability.Internal
    @JsonCreator
    public CoreBucketSettingsJson(@JsonProperty(value="name") String name, @JsonProperty(value="controllers") Map<String, String> controllers, @JsonProperty(value="quota") Map<String, Long> quota, @JsonProperty(value="replicaNumber") int numReplicas, @JsonProperty(value="replicaIndex") boolean replicaIndex, @JsonProperty(value="maxTTL") int maxTTL, @JsonProperty(value="compressionMode") CoreCompressionMode compressionMode, @JsonProperty(value="bucketType") BucketType bucketType, @JsonProperty(value="conflictResolutionType") CoreConflictResolutionType conflictResolutionType, @JsonProperty(value="evictionPolicy") CoreEvictionPolicyType evictionPolicy, @JsonProperty(value="durabilityMinLevel") String durabilityMinLevel, @JsonProperty(value="storageBackend") CoreStorageBackend storageBackend, @JsonProperty(value="numVBuckets") Integer numVBuckets, @JsonProperty(value="historyRetentionCollectionDefault") Boolean historyRetentionCollectionDefault, @JsonProperty(value="historyRetentionBytes") Long historyRetentionBytes, @JsonProperty(value="historyRetentionSeconds") Long historyRetentionDurationSeconds) {
        this.name = name;
        this.flushEnabled = controllers.containsKey("flush");
        this.ramQuotaMB = CoreBucketSettingsJson.ramQuotaToMB(quota.get("rawRAM"));
        this.numReplicas = numReplicas;
        this.replicaIndexes = replicaIndex;
        this.maxExpiry = Duration.ofSeconds(maxTTL);
        this.compressionMode = compressionMode;
        this.bucketType = bucketType;
        this.conflictResolutionType = conflictResolutionType;
        this.evictionPolicy = evictionPolicy;
        this.minimumDurabilityLevel = DurabilityLevel.decodeFromManagementApi(durabilityMinLevel);
        this.storageBackend = storageBackend;
        this.historyRetentionCollectionDefault = historyRetentionCollectionDefault;
        this.historyRetentionBytes = historyRetentionBytes;
        this.historyRetentionDuration = historyRetentionDurationSeconds == null ? null : Duration.ofSeconds(historyRetentionDurationSeconds);
        this.numVBuckets = numVBuckets;
    }

    static CoreBucketSettings create(byte[] bytes) {
        JsonNode node = Mapper.decodeIntoTree(bytes);
        return CoreBucketSettingsJson.create(node);
    }

    static CoreBucketSettings create(JsonNode node) {
        return Mapper.convertValue((Object)node, CoreBucketSettingsJson.class);
    }

    public static long ramQuotaToMB(long ramQuotaBytes) {
        long BYTES_PER_MEGABYTE = 0x100000L;
        return ramQuotaBytes == 0L ? 0L : ramQuotaBytes / 0x100000L;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Boolean flushEnabled() {
        return this.flushEnabled;
    }

    @Override
    public Long ramQuotaMB() {
        return this.ramQuotaMB;
    }

    @Override
    public Integer numReplicas() {
        return this.numReplicas;
    }

    @Override
    public Boolean replicaIndexes() {
        return this.replicaIndexes;
    }

    @Override
    public DurabilityLevel minimumDurabilityLevel() {
        return this.minimumDurabilityLevel;
    }

    @Override
    public Duration maxExpiry() {
        return this.maxExpiry;
    }

    @Override
    public CoreCompressionMode compressionMode() {
        return this.compressionMode;
    }

    @Override
    public BucketType bucketType() {
        return this.bucketType;
    }

    @Override
    public CoreConflictResolutionType conflictResolutionType() {
        return this.conflictResolutionType;
    }

    @Override
    public CoreStorageBackend storageBackend() {
        return this.storageBackend;
    }

    @Override
    @Nullable
    public Integer numVBuckets() {
        return this.numVBuckets;
    }

    @Override
    public CoreEvictionPolicyType evictionPolicy() {
        return this.evictionPolicy;
    }

    @Override
    @Nullable
    public Boolean historyRetentionCollectionDefault() {
        return this.historyRetentionCollectionDefault;
    }

    @Override
    @Nullable
    public Long historyRetentionBytes() {
        return this.historyRetentionBytes;
    }

    @Override
    @Nullable
    public Duration historyRetentionDuration() {
        return this.historyRetentionDuration;
    }

    public String toString() {
        return "BucketSettings{name='" + RedactableArgument.redactMeta(this.name) + '\'' + ", flushEnabled=" + this.flushEnabled + ", ramQuotaMB=" + this.ramQuotaMB + ", numReplicas=" + this.numReplicas + ", replicaIndexes=" + this.replicaIndexes + ", maxExpiry=" + this.maxExpiry.getSeconds() + ", compressionMode=" + (Object)((Object)this.compressionMode) + ", bucketType=" + (Object)((Object)this.bucketType) + ", conflictResolutionType=" + (Object)((Object)this.conflictResolutionType) + ", evictionPolicy=" + (Object)((Object)this.evictionPolicy) + ", minimumDurabilityLevel=" + (Object)((Object)this.minimumDurabilityLevel) + ", storageBackend=" + this.storageBackend + ", numVBuckets=" + this.numVBuckets + ", historyRetentionCollectionDefault=" + this.historyRetentionCollectionDefault + ", historyRetentionBytes=" + this.historyRetentionBytes + ", historyRetentionDuration=" + this.historyRetentionDuration + '}';
    }
}

