/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.classic.analytics;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.topology.ClusterIdentifier;
import java.time.Duration;
import org.jspecify.annotations.Nullable;
import reactor.core.publisher.Mono;

@Stability.Internal
public class AnalyticsHelper {
    private static volatile boolean skipClusterTypeCheck = false;

    private AnalyticsHelper() {
    }

    public static void skipClusterTypeCheck() {
        skipClusterTypeCheck = true;
    }

    public static Mono<Void> requireCouchbaseServer(Core core, Duration timeout) {
        if (skipClusterTypeCheck) {
            return Mono.empty();
        }
        return core.waitForClusterTopology(timeout).mapNotNull(clusterTopology -> {
            if (AnalyticsHelper.isEnterpriseAnalytics(clusterTopology.id())) {
                throw new CouchbaseException("This SDK is for Couchbase Server (operational) clusters, but the remote cluster is an Enterprise Analytics cluster. Please use the Enterprise Analytics SDK to access this cluster.");
            }
            return null;
        });
    }

    private static boolean isEnterpriseAnalytics(@Nullable ClusterIdentifier clusterId) {
        return clusterId != null && "analytics".equals(clusterId.product());
    }
}

