/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.security.user;

import java.time.Instant;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.security.user.SMSubject;

public class SMUser
extends SMSubject {
    private String[] userTeams;
    private boolean enabled;
    private String authRole;
    @Nullable
    private Instant disableDate;
    @Nullable
    private String disabledBy;
    @Nullable
    private String disableReason;

    public SMUser(@NotNull String userId, boolean enabled, @Nullable String authRole) {
        this(userId, null, new String[0], enabled, authRole, true, null, null, null);
    }

    public SMUser(@NotNull String userId, boolean enabled, @Nullable String authRole, boolean secretStorage, @Nullable Instant disableDate, @Nullable String disabledBy, @Nullable String disableReason) {
        this(userId, null, new String[0], enabled, authRole, secretStorage, disableDate, disabledBy, disableReason);
    }

    public SMUser(@NotNull String userId, @Nullable Map<String, String> metaParameters, @NotNull String[] teams, boolean enabled, @Nullable String authRole, boolean secretStorage, @Nullable Instant disableDate, @Nullable String disabledBy, @Nullable String disableReason) {
        super(userId, metaParameters, secretStorage);
        this.userTeams = teams;
        this.enabled = enabled;
        this.authRole = authRole;
        this.disableDate = disableDate;
        this.disabledBy = disabledBy;
        this.disableReason = disableReason;
    }

    @NotNull
    public String getName() {
        return this.subjectId;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getUserId() {
        return this.subjectId;
    }

    @NotNull
    public String[] getUserTeams() {
        return this.userTeams;
    }

    public void setUserTeams(@NotNull String[] userTeams) {
        this.userTeams = userTeams;
    }

    @Property(viewable=true, order=3)
    public boolean isEnabled() {
        return this.enabled;
    }

    public void enableUser(boolean enabled) {
        this.enabled = enabled;
    }

    @Property(viewable=true, order=2)
    public String getAuthRole() {
        return this.authRole;
    }

    public void setAuthRole(String authRole) {
        this.authRole = authRole;
    }

    @Nullable
    public Instant getDisableDate() {
        return this.enabled ? null : this.disableDate;
    }

    @Nullable
    public String getDisabledBy() {
        return this.enabled ? null : this.disabledBy;
    }

    @Nullable
    public String getDisableReason() {
        return this.enabled ? null : this.disableReason;
    }
}

