/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.security.user;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.security.user.SMSubject;
import org.jkiss.utils.CommonUtils;

public class SMTeam
extends SMSubject {
    @Nullable
    private String teamName;
    @Nullable
    private String description;
    @NotNull
    private Set<String> permissions = new LinkedHashSet<String>();

    public SMTeam(@NotNull String teamId) {
        this(teamId, null, null, true);
    }

    public SMTeam(@NotNull String teamId, @Nullable String name, @Nullable String description, boolean secretStorage) {
        super(teamId, null, secretStorage);
        this.teamName = name;
        this.description = description;
    }

    @NotNull
    public String getName() {
        return CommonUtils.isEmpty((String)this.teamName) ? this.subjectId : this.teamName;
    }

    @Property(viewable=true, order=1)
    public String getTeamId() {
        return this.subjectId;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getTeamName() {
        return CommonUtils.isEmpty((String)this.teamName) ? this.subjectId : this.teamName;
    }

    public void setTeamName(@Nullable String teamName) {
        this.teamName = teamName;
    }

    @Property(viewable=true, order=3)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @NotNull
    public Set<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(@NotNull Set<String> permissions) {
        this.permissions = permissions;
    }

    public void addPermission(String permission) {
        this.permissions.add(permission);
    }

    public String toString() {
        return this.getTeamId();
    }
}

