/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.ui.editor;

import com.dbeaver.data.compare.model.DCChangeList;
import com.dbeaver.data.compare.model.DCChangeOrder;
import com.dbeaver.data.compare.model.DCChangeRelation;
import com.dbeaver.data.compare.model.DCChangeSet;
import com.dbeaver.data.compare.model.DCInput;
import com.dbeaver.data.compare.model.DCIterator;
import com.dbeaver.data.compare.model.DCSummary;
import com.dbeaver.data.compare.ui.editor.DCCompareViewer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDAttributeDecorator;
import org.jkiss.dbeaver.model.data.DBDAttributeValue;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetListener;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.QueryResultsDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetThemeSettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.SpreadsheetPresentation;

public class DCCompareViewerPane
extends Composite
implements IResultSetContainer,
IResultSetListener {
    private final DCCompareViewer compareViewer;
    private final ResultSetViewer resultSetViewer;
    private final Map<Integer, DCChangeSet> changeSetByRow = new HashMap<Integer, DCChangeSet>();
    private final Map<DCChangeSet, Integer> rowByChangeSet = new HashMap<DCChangeSet, Integer>();
    private DCSummary summary;
    private DCChangeRelation relation;

    public DCCompareViewerPane(@NotNull Composite parent, @NotNull DCCompareViewer viewer, @NotNull DCChangeRelation relation) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.compareViewer = viewer;
        this.resultSetViewer = new ResultSetViewer((Composite)this, viewer.getCompareConfiguration().getContainer().getWorkbenchPart().getSite(), (IResultSetContainer)this);
        this.resultSetViewer.addListener((IResultSetListener)this);
        this.relation = relation;
    }

    public void refresh() {
        this.resultSetViewer.resetHistory();
        this.resultSetViewer.refresh();
        this.changeSetByRow.clear();
        this.rowByChangeSet.clear();
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return this.summary != null ? DBUtils.getDefaultContext((DBSObject)this.getInput().getContainer(), (boolean)false) : null;
    }

    @Nullable
    public DBPProject getProject() {
        return this.summary != null ? DBUtils.getObjectOwnerProject((DBSObject)this.getInput().getContainer()) : null;
    }

    @NotNull
    public IResultSetController getResultSetController() {
        return this.resultSetViewer;
    }

    @Nullable
    public DBSDataContainer getDataContainer() {
        return this.summary != null ? new FilteredDataContainer(this.getInput().getContainer()) : null;
    }

    public boolean isReadyToRun() {
        return true;
    }

    public void openNewContainer(DBRProgressMonitor monitor, @NotNull DBSDataContainer dataContainer, @NotNull DBDDataFilter newFilter) {
        DBWorkbench.getPlatformUI().showError("Data container", "Not supported");
    }

    public IResultSetDecorator createResultSetDecorator() {
        return new ResultSetDecorator();
    }

    public void dispose() {
        this.resultSetViewer.removeListener((IResultSetListener)this);
        super.dispose();
    }

    public void handleResultSetLoad() {
        ResultSetModel model = this.resultSetViewer.getModel();
        DBSAttributeBase[] keys = this.getInput().getKeys();
        Collection mappings = this.summary.getSettings().getMappings(this.relation);
        DBDAttributeBinding[] dBDAttributeBindingArray = model.getAttributes();
        int n = dBDAttributeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding binding = dBDAttributeBindingArray[n2];
            boolean isKey = Arrays.stream(keys).anyMatch(attr -> binding.matches(attr, true));
            boolean isMapped = mappings.stream().anyMatch(attr -> binding.matches(attr, true));
            model.setAttributeVisibility(binding, isKey || isMapped);
            ++n2;
        }
        this.compareViewer.signalDataLoad(this);
    }

    public void handleResultSetChange() {
    }

    public void handleResultSetSelectionChange(SelectionChangedEvent event) {
        List rows = ((IResultSetSelection)event.getSelection()).getSelectedRows();
        if (rows.isEmpty()) {
            return;
        }
        ResultSetRow selectedRow = (ResultSetRow)rows.get(0);
        DCCompareViewerPane oppositePane = this.compareViewer.getOppositePane(this);
        ResultSetRow oppositeRow = oppositePane.getResultSetRow(this.changeSetByRow.get(selectedRow.getVisualNumber()));
        if (oppositeRow != null) {
            int index = oppositeRow.getRowNumber();
            Spreadsheet spreadsheet = this.getSpreadsheet();
            Spreadsheet oppositeSpreadsheet = oppositePane.getSpreadsheet();
            if (spreadsheet != null && oppositeSpreadsheet != null) {
                int topIndex = spreadsheet.getTopIndex();
                int topOffset = selectedRow.getVisualNumber() - topIndex;
                oppositeSpreadsheet.setSelection(index);
                oppositeSpreadsheet.showItem(index, topOffset);
                this.compareViewer.redrawRuler();
            }
        }
    }

    @NotNull
    public ResultSetViewer getResultSetViewer() {
        return this.resultSetViewer;
    }

    @Nullable
    public SpreadsheetPresentation getPresentation() {
        IResultSetPresentation presentation = this.resultSetViewer.getActivePresentation();
        return presentation instanceof SpreadsheetPresentation ? (SpreadsheetPresentation)presentation : null;
    }

    @Nullable
    public Spreadsheet getSpreadsheet() {
        SpreadsheetPresentation presentation = this.getPresentation();
        return presentation != null ? presentation.getSpreadsheet() : null;
    }

    @Nullable
    public ResultSetRow getResultSetRow(@NotNull DCChangeSet changeSet) {
        ResultSetModel model = this.resultSetViewer.getModel();
        Integer index = this.rowByChangeSet.get(changeSet);
        return index != null && index < model.getRowCount() ? model.getRow(index.intValue()) : null;
    }

    public void setInput(@NotNull DCSummary summary, @NotNull DCChangeRelation relation) {
        this.summary = summary;
        this.relation = relation;
    }

    @NotNull
    private DCInput getInput() {
        return this.summary.getSettings().getInput(this.relation);
    }

    @NotNull
    public DCChangeRelation getRelation() {
        return this.relation;
    }

    @NotNull
    private DBDDataFilter createFilter(@NotNull ChangeSetRange range) throws DBCException {
        DBSAttributeBase[] keys = this.getInput().getKeys();
        List values = IntStream.range(0, keys.length).mapToObj(ArrayList::new).collect(Collectors.toList());
        DCSummary summary = this.compareViewer.getSummary();
        DCChangeList changeList = summary.getChangeList();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (DCIterator it = changeList.iterator(range.offset, Long.MAX_VALUE, DCChangeOrder.DEFAULT);){
                int i = 0;
                while ((long)i < range.count && it.hasNext()) {
                    DCChangeSet changeSet = (DCChangeSet)it.next();
                    if (!changeSet.getChangeType().isRelated(this.relation)) continue;
                    int j = 0;
                    while (j < keys.length) {
                        ((List)values.get(j)).add(changeSet.getKeys()[j].getValue());
                        ++j;
                    }
                    int offset = (int)range.offset + i;
                    this.changeSetByRow.put(offset, changeSet);
                    this.rowByChangeSet.put(changeSet, offset);
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (DBException e) {
            throw new DBCException("Error creating data filter", (Throwable)e);
        }
        DBDDataFilter filter = new DBDDataFilter(this.getInput().getFilter());
        filter.setUseDisjunctiveNormalForm(true);
        int i = 0;
        while (i < keys.length) {
            DBDAttributeConstraint constraint = Objects.requireNonNull(filter.getConstraint(keys[i], true));
            constraint.setOperator(DBCLogicalOperator.IN);
            constraint.setValue((Object)((List)values.get(i)).toArray());
            ++i;
        }
        return filter;
    }

    private record ChangeSetRange(long offset, long count) {
    }

    private class FilteredDataContainer
    implements DBSDataContainer {
        private final DBSDataContainer delegate;

        public FilteredDataContainer(DBSDataContainer delegate) {
            this.delegate = delegate;
        }

        @NotNull
        public DBCStatistics readData(@Nullable DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @Nullable DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBException {
            ChangeSetRange range = new ChangeSetRange(firstRow < 0L ? 0L : firstRow, maxRows < 0L ? Long.MAX_VALUE : maxRows);
            return this.delegate.readData(source, session, dataReceiver, DCCompareViewerPane.this.createFilter(range), firstRow, maxRows, flags, fetchSize);
        }

        public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) {
            if (DCCompareViewerPane.this.relation == DCChangeRelation.SOURCE) {
                return DCCompareViewerPane.this.summary.getModifiedRowsCount() + DCCompareViewerPane.this.summary.getDeletedRowsCount();
            }
            return DCCompareViewerPane.this.summary.getModifiedRowsCount() + DCCompareViewerPane.this.summary.getInsertedRowsCount();
        }

        @NotNull
        public String getName() {
            return this.delegate.getName();
        }

        @Nullable
        public String getDescription() {
            return this.delegate.getDescription();
        }

        public boolean isPersisted() {
            return this.delegate.isPersisted();
        }

        @Nullable
        public DBSObject getParentObject() {
            return this.delegate;
        }

        @NotNull
        public DBPDataSource getDataSource() {
            return this.delegate.getDataSource();
        }

        @NotNull
        public String[] getSupportedFeatures() {
            return new String[]{"data.select"};
        }
    }

    private class ResultSetDecorator
    extends QueryResultsDecorator
    implements DBDAttributeDecorator {
        private ResultSetDecorator() {
        }

        public long getDecoratorFeatures() {
            return 130L;
        }

        public String getPreferredPresentation() {
            return "spreadsheet";
        }

        @Nullable
        public DBDAttributeDecorator getDataLabelProvider() {
            return this;
        }

        @Nullable
        public String getCellForeground(@NotNull DBDAttributeBinding attribute, int row) {
            return null;
        }

        @Nullable
        public String getCellBackground(@NotNull DBDAttributeBinding attribute, int row) {
            DCChangeSet changeSet = DCCompareViewerPane.this.changeSetByRow.get(row);
            SpreadsheetPresentation presentation = DCCompareViewerPane.this.getPresentation();
            if (changeSet == null || presentation == null) {
                return null;
            }
            switch (changeSet.getChangeType()) {
                case INSERT: {
                    if (!DCCompareViewerPane.this.relation.isTarget()) break;
                    return StringConverter.asString((RGB)ResultSetThemeSettings.instance.backgroundAdded.getRGB());
                }
                case DELETE: {
                    if (!DCCompareViewerPane.this.relation.isSource()) break;
                    return StringConverter.asString((RGB)presentation.getBackgroundDeleted().getRGB());
                }
                case UPDATE: {
                    DBDAttributeValue[] dBDAttributeValueArray = changeSet.getSourceValues();
                    int n = dBDAttributeValueArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DBDAttributeValue value = dBDAttributeValueArray[n2];
                        DBSAttributeBase source = DCCompareViewerPane.this.relation.isSource() ? value.getAttribute() : (DBSAttributeBase)DCCompareViewerPane.this.summary.getSettings().getMappings().get(value.getAttribute());
                        if (source.getName().equals(attribute.getName())) {
                            return StringConverter.asString((RGB)presentation.getBackgroundModified().getRGB());
                        }
                        ++n2;
                    }
                    break;
                }
            }
            return null;
        }
    }
}

