/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.ui.dialog;

import com.dbeaver.data.compare.model.DCChangeOrder;
import com.dbeaver.data.compare.model.DCChangeRelation;
import com.dbeaver.data.compare.model.DCRegistry;
import com.dbeaver.data.compare.model.DCSummary;
import com.dbeaver.data.compare.model.DCUtils;
import com.dbeaver.data.compare.model.exporter.DCExporterDescriptor;
import com.dbeaver.data.compare.ui.editor.DCCompareViewer;
import com.dbeaver.data.compare.ui.internal.DCMessages;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class ExportChangesDialog
extends BaseDialog {
    private static final int MAX_ACTIONS_COUNT = 1000;
    private final DCSummary summary;
    private final DCCompareViewer viewer;
    private final UIServiceSQL service;
    private final AbstractJob previewUpdateJob = new AbstractJob("Update diff preview"){

        protected IStatus run(DBRProgressMonitor monitor) {
            try {
                ExportChangesDialog.this.updatePreview(monitor, ExportChangesDialog.this.relation);
                return Status.OK_STATUS;
            }
            catch (Exception e) {
                return GeneralUtils.makeExceptionStatus((String)("Unable to generate preview: " + e.getMessage()), (Throwable)e);
            }
        }
    };
    private Group optionsGroup;
    private Object sqlPanel;
    private DCExporterDescriptor exporterDescriptor;
    private String sqlText;
    private DCChangeRelation relation = DCChangeRelation.SOURCE;
    private DCChangeOrder order = DCChangeOrder.DEFAULT;

    public ExportChangesDialog(@NotNull DCCompareViewer viewer, @NotNull DCSummary summary) {
        super(viewer.getControl().getShell(), "Export Changes", null);
        this.summary = summary;
        this.viewer = viewer;
        this.service = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = new Composite(super.createDialogArea(parent), 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(500, 400).create());
        try {
            UIUtils.createControlLabel((Composite)composite, (String)"Preview of the output");
            Composite wrapper = new Composite(composite, 2048);
            wrapper.setLayout((Layout)new FillLayout());
            wrapper.setLayoutData((Object)new GridData(1808));
            this.sqlPanel = this.service.createSQLPanel((Object)this.viewer.getPane(this.relation).getResultSetViewer().getSite(), (Object)wrapper, () -> this.viewer.getPane(this.relation).getResultSetViewer().getExecutionContext(), "Preview SQL diff", true, "");
        }
        catch (DBException e2) {
            DBWorkbench.getPlatformUI().showError("Can't create SQL panel", "Error creating SQL panel", (Throwable)e2);
        }
        this.optionsGroup = UIUtils.createControlGroup((Composite)composite, (String)"Options", (int)3, (int)768, (int)0);
        UIUtils.createControlLabel((Composite)this.optionsGroup, (String)"Apply changes to");
        Button sourceTableButton = UIUtils.createRadioButton((Composite)this.optionsGroup, (String)"&Source table", (Object)true, null);
        Button targetTableButton = UIUtils.createRadioButton((Composite)this.optionsGroup, (String)"&Target table", (Object)false, null);
        Combo formatCombo = UIUtils.createLabelCombo((Composite)this.optionsGroup, (String)"&Format", (int)12);
        for (DCExporterDescriptor exporter : DCRegistry.getInstance().getExporters()) {
            formatCombo.add(exporter.getName());
            formatCombo.setData(exporter.getName(), (Object)exporter);
        }
        formatCombo.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        formatCombo.setText(DCRegistry.getInstance().getExporter("sql").getName());
        Combo orderCombo = UIUtils.createLabelCombo((Composite)this.optionsGroup, (String)"&Ordering", (int)12);
        orderCombo.setToolTipText(DCMessages.data_compare_wizard_settings_group_general_output_order_tip);
        orderCombo.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        DCChangeOrder[] dCChangeOrderArray = DCChangeOrder.values();
        int n = dCChangeOrderArray.length;
        int n2 = 0;
        while (n2 < n) {
            DCChangeOrder value = dCChangeOrderArray[n2];
            orderCombo.add(value.localizedName());
            ++n2;
        }
        orderCombo.select(0);
        SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> {
            UIUtils.enableWithChildren((Control)this.optionsGroup, (boolean)false);
            this.relation = sourceTableButton.getSelection() ? DCChangeRelation.SOURCE : DCChangeRelation.TARGET;
            this.order = DCChangeOrder.values()[orderCombo.getSelectionIndex()];
            this.exporterDescriptor = (DCExporterDescriptor)formatCombo.getData(formatCombo.getText());
            this.previewUpdateJob.schedule();
        });
        formatCombo.addSelectionListener(listener);
        orderCombo.addSelectionListener(listener);
        sourceTableButton.addSelectionListener(listener);
        targetTableButton.addSelectionListener(listener);
        sourceTableButton.setSelection(true);
        sourceTableButton.notifyListeners(13, new Event());
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "&Export...", false);
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0 && CommonUtils.isNotEmpty((String)this.sqlText)) {
            if (this.exportChanges(this.relation)) {
                this.close();
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private boolean exportChanges(@NotNull DCChangeRelation relation) {
        File file = DialogUtils.selectFileForSave((Shell)this.getShell(), (String)"Select output file", (String[])new String[]{"*." + this.exporterDescriptor.getExtension()}, null);
        if (file != null) {
            try {
                UIUtils.runInProgressDialog(monitor -> {
                    try {
                        DCUtils.exportChanges((DBRProgressMonitor)monitor, (DCSummary)this.summary, (DCExporterDescriptor)this.exporterDescriptor, (Path)file.toPath(), (DCChangeRelation)relation, (DCChangeOrder)this.order);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                });
                return true;
            }
            catch (InvocationTargetException e) {
                DBWorkbench.getPlatformUI().showError("Export error", "Error exporting changes", e.getCause());
            }
        }
        return false;
    }

    private void updatePreview(@NotNull DBRProgressMonitor monitor, @NotNull DCChangeRelation relation) throws DBException, IOException {
        try {
            this.sqlText = "-- No preview available";
            this.sqlText = this.generatePreview(monitor, relation);
        }
        catch (Throwable throwable) {
            UIUtils.syncExec(() -> {
                this.service.setSQLPanelText(this.sqlPanel, this.sqlText);
                UIUtils.enableWithChildren((Control)this.optionsGroup, (boolean)true);
            });
            throw throwable;
        }
        UIUtils.syncExec(() -> {
            this.service.setSQLPanelText(this.sqlPanel, this.sqlText);
            UIUtils.enableWithChildren((Control)this.optionsGroup, (boolean)true);
        });
    }

    @NotNull
    private String generatePreview(@NotNull DBRProgressMonitor monitor, @NotNull DCChangeRelation relation) throws DBException, IOException {
        StringWriter writer = new StringWriter();
        DCUtils.exportChanges((DBRProgressMonitor)monitor, (DCSummary)this.summary, (DCExporterDescriptor)this.exporterDescriptor, (Writer)writer, (DCChangeRelation)relation, (DCChangeOrder)this.order, (long)0L, (long)1000L);
        return writer.toString();
    }
}

