/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.upd.impl;

import com.dbeaver.jdbc.upd.protocol.UPDColumnFlag;
import com.dbeaver.jdbc.upd.protocol.UPDException;
import com.dbeaver.jdbc.upd.protocol.UPDObjectId;
import com.dbeaver.jdbc.upd.protocol.UPDResultSet;
import com.dbeaver.jdbc.upd.protocol.UPDResultSetMetaData;
import com.dbeaver.jdbc.upd.protocol.UPDStatementInput;
import com.dbeaver.jdbc.upd.protocol.UPDStatementParameter;
import com.dbeaver.jdbc.upd.protocol.UPDUtils;
import com.dbeaver.jdbc.upd.protocol.UPDValueNull;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.rpc.RpcConstants;

public class UPDServerUtils {
    private static final Log log = Log.getLog(UPDServerUtils.class);

    @NotNull
    public static UPDResultSet createFrom(ResultSet srcResultSet) throws SQLException {
        return UPDServerUtils.createFrom(new UPDObjectId(0L), true, srcResultSet);
    }

    @NotNull
    public static UPDResultSet createFrom(UPDObjectId objectId, boolean readMetaData, ResultSet srcResultSet) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            try {
                UPDResultSetMetaData metaData;
                int i;
                int columnCount;
                if (readMetaData) {
                    ResultSetMetaData srcMetaData = srcResultSet.getMetaData();
                    columnCount = srcMetaData.getColumnCount();
                    UPDResultSetMetaData.ColumnInfo[] columns = new UPDResultSetMetaData.ColumnInfo[columnCount];
                    i = 0;
                    while (i < columnCount) {
                        String catalog = null;
                        String schema = null;
                        String table = null;
                        String columnName = null;
                        String label = null;
                        int type = 1111;
                        String typeName = null;
                        int displaySize = 0;
                        String className = null;
                        int precision = 0;
                        int scale = 0;
                        EnumSet<UPDColumnFlag> flags = EnumSet.noneOf(UPDColumnFlag.class);
                        try {
                            catalog = srcMetaData.getCatalogName(i + 1);
                        }
                        catch (Exception e) {
                            log.debug((Object)e);
                        }
                        try {
                            schema = srcMetaData.getSchemaName(i + 1);
                        }
                        catch (Exception e) {
                            log.debug((Object)e);
                        }
                        try {
                            table = srcMetaData.getTableName(i + 1);
                        }
                        catch (Exception e) {
                            log.debug((Object)e);
                        }
                        try {
                            columnName = srcMetaData.getColumnName(i + 1);
                        }
                        catch (Exception e) {
                            log.debug((Object)e);
                        }
                        try {
                            label = srcMetaData.getColumnLabel(i + 1);
                        }
                        catch (Exception e) {
                            log.debug((Object)e);
                        }
                        try {
                            type = srcMetaData.getColumnType(i + 1);
                        }
                        catch (Exception e) {
                            log.debug((Object)e);
                        }
                        try {
                            typeName = srcMetaData.getColumnTypeName(i + 1);
                        }
                        catch (Exception e) {
                            log.debug((Object)e);
                        }
                        try {
                            displaySize = srcMetaData.getColumnDisplaySize(i + 1);
                        }
                        catch (Exception e) {
                            log.debug((Object)e);
                        }
                        try {
                            className = srcMetaData.getColumnClassName(i + 1);
                        }
                        catch (Exception e) {
                            log.debug((Object)e);
                        }
                        try {
                            scale = srcMetaData.getScale(i + 1);
                        }
                        catch (Exception e) {
                            log.debug((Object)e);
                        }
                        try {
                            precision = srcMetaData.getPrecision(i + 1);
                        }
                        catch (Exception e) {
                            log.debug((Object)e);
                        }
                        try {
                            if (srcMetaData.isNullable(i + 1) == 1) {
                                flags.add(UPDColumnFlag.NULLABLE);
                            }
                            if (srcMetaData.isSearchable(i + 1)) {
                                flags.add(UPDColumnFlag.SEARCHABLE);
                            }
                            if (srcMetaData.isWritable(i + 1)) {
                                flags.add(UPDColumnFlag.WRITABLE);
                            }
                            if (srcMetaData.isAutoIncrement(i + 1)) {
                                flags.add(UPDColumnFlag.AUTO_INCREMENT);
                            }
                            if (srcMetaData.isCurrency(i + 1)) {
                                flags.add(UPDColumnFlag.CURRENCY);
                            }
                            if (srcMetaData.isCaseSensitive(i + 1)) {
                                flags.add(UPDColumnFlag.CASE_SENSITIVE);
                            }
                            if (srcMetaData.isDefinitelyWritable(i + 1)) {
                                flags.add(UPDColumnFlag.DEFINITELY_WRITABLE);
                            }
                            if (srcMetaData.isReadOnly(i + 1)) {
                                flags.add(UPDColumnFlag.READ_ONLY);
                            }
                            if (srcMetaData.isSigned(i + 1)) {
                                flags.add(UPDColumnFlag.SIGNED);
                            }
                        }
                        catch (Exception e) {
                            log.debug((Object)e);
                        }
                        columns[i] = new UPDResultSetMetaData.ColumnInfo(catalog, schema, table, columnName, label, type, typeName, displaySize, className, Integer.valueOf(scale), Integer.valueOf(precision), flags);
                        ++i;
                    }
                    metaData = new UPDResultSetMetaData(columns);
                } else {
                    metaData = null;
                    columnCount = srcResultSet.getMetaData().getColumnCount();
                }
                ArrayList<Object[]> data = new ArrayList<Object[]>();
                while (srcResultSet.next()) {
                    Object[] row = new Object[columnCount];
                    i = 0;
                    while (i < columnCount) {
                        Object value = srcResultSet.getObject(i + 1);
                        row[i] = UPDUtils.toStringPresentation((Object)value);
                        ++i;
                    }
                    data.add(row);
                }
                UPDResultSet uPDResultSet = metaData == null ? new UPDResultSet(objectId, data) : new UPDResultSet(objectId, metaData, data);
                return uPDResultSet;
            }
            finally {
                if (srcResultSet != null) {
                    srcResultSet.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static void setStatementParameters(PreparedStatement dbStat, @NotNull UPDStatementInput input) throws SQLException {
        List parameters = input.getParameters();
        if (CommonUtils.isEmpty((Collection)parameters)) {
            return;
        }
        for (UPDStatementParameter param : parameters) {
            if (param.index() <= 0) {
                if (dbStat instanceof CallableStatement) {
                    CallableStatement cs = (CallableStatement)dbStat;
                    UPDServerUtils.setNamedParameter(cs, param);
                    continue;
                }
                throw new UPDException("Named parameters are not supported in prepared statements");
            }
            try {
                UPDServerUtils.setIndexedParameter(dbStat, param);
            }
            catch (ParseException e) {
                throw new UPDException("Error setting parameter " + param.index(), (Throwable)e);
            }
        }
    }

    private static void setIndexedParameter(PreparedStatement dbStat, UPDStatementParameter param) throws SQLException, ParseException {
        int index = param.index();
        String value = param.value();
        switch (param.type()) {
            case 0: {
                dbStat.setNull(index, ((UPDValueNull)value).getSqlType());
                break;
            }
            case -6: {
                dbStat.setByte(index, (byte)CommonUtils.toInt((Object)value));
                break;
            }
            case 5: {
                dbStat.setShort(index, (short)CommonUtils.toInt((Object)value));
                break;
            }
            case 4: {
                dbStat.setInt(index, CommonUtils.toInt((Object)value));
                break;
            }
            case -5: {
                dbStat.setLong(index, CommonUtils.toLong((Object)value));
                break;
            }
            case 12: {
                dbStat.setString(index, CommonUtils.toString((Object)value, null));
                break;
            }
            case 16: {
                dbStat.setBoolean(index, CommonUtils.toBoolean((Object)value));
                break;
            }
            case 91: {
                dbStat.setDate(index, UPDServerUtils.toDate(value));
                break;
            }
            case 92: {
                dbStat.setTime(index, UPDServerUtils.toTime(value));
                break;
            }
            case 93: {
                dbStat.setTimestamp(index, UPDServerUtils.toTimestamp(value));
                break;
            }
            case 1111: {
                dbStat.setObject(index, value);
                break;
            }
            default: {
                throw new UPDException("Unsupported parameter type: " + param.type());
            }
        }
    }

    @Nullable
    private static Date toDate(Object value) throws ParseException, UPDException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String string = (String)value;
            java.util.Date date = RpcConstants.ISO_DATE_FORMAT.parse(string);
            return new Date(date.getTime());
        }
        throw new UPDException("Unsupported date value: " + String.valueOf(value));
    }

    @Nullable
    private static Time toTime(@Nullable Object value) throws ParseException, UPDException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String string = (String)value;
            java.util.Date date = RpcConstants.ISO_TIME_FORMAT.parse(string);
            return new Time(date.getTime());
        }
        throw new UPDException("Unsupported time value: " + String.valueOf(value));
    }

    @Nullable
    private static Timestamp toTimestamp(@Nullable Object value) throws UPDException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            try {
                java.util.Date date = RpcConstants.ISO_TIMESTAMP_FORMAT.parse((String)value);
                return new Timestamp(date.getTime());
            }
            catch (ParseException e) {
                log.debug((Object)e);
                return null;
            }
        }
        throw new UPDException("Unsupported timestamp value: " + String.valueOf(value));
    }

    private static void setNamedParameter(CallableStatement dbStat, UPDStatementParameter param) throws SQLException {
        throw new UPDException("Named parameters are not supported");
    }
}

