/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redshift.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.session.PostgreSession;
import org.jkiss.dbeaver.ext.postgresql.model.session.PostgreSessionManager;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.utils.CommonUtils;

public class RedshiftSessionManager
extends PostgreSessionManager {
    public RedshiftSessionManager(PostgreDataSource dataSource) {
        super(dataSource);
    }

    @NotNull
    public List<PostgreSession> getSessions(@NotNull DBCSession session, @NotNull Map<String, Object> options) throws DBException {
        HashSet<Integer> sessionIds = new HashSet<Integer>();
        List sessions = super.getSessions(session, options);
        Iterator iter = sessions.iterator();
        while (iter.hasNext()) {
            PostgreSession next = (PostgreSession)iter.next();
            if (sessionIds.contains(next.getPid())) {
                iter.remove();
                continue;
            }
            if (CommonUtils.isEmpty((String)next.getBriefQuery())) continue;
            sessionIds.add(next.getPid());
        }
        return sessions;
    }

    @NotNull
    public String generateSessionReadQuery(@NotNull Map<String, Object> options) {
        return "select s.process AS pid,\n       s.user_name AS usename,\n       s.db_name AS datname,\n       q.querytxt AS query,\n       q.starttime AS query_start,\n       q.endtime AS query_end,\n       NULL as client_hostname, NULL as client_addr, NULL as client_port\nfrom stv_sessions s\nleft join stl_query q on s.process = q.pid\nORDER BY endtime desc";
    }
}

