/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.views;

import com.dbeaver.db.mongodb.MongoDBMessages;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class FerretDBConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private final ModifyListener textListener = e -> this.site.updateButtons();
    private Composite settingsGroup;
    private Composite urlGroup;
    private Composite seedsGroup;
    private Button typeManualRadio;
    private Text urlText;
    private Text hostText;
    private Text portText;
    private Text databaseNameText;
    private Button typeURLRadio;

    public void createControl(Composite parent) {
        this.createSettingsGroup(parent);
        this.createAddressGroup();
        this.createAuthPanel(this.settingsGroup, 1);
        this.createDriverPanel(this.settingsGroup);
        this.setControl((Control)this.settingsGroup);
    }

    public Image getImage() {
        DBPImage icon = this.getSite().getDriver().getIconBig();
        return DBeaverIcons.getImage((DBPImage)icon);
    }

    public boolean isComplete() {
        if (this.typeManualRadio.getSelection()) {
            return !CommonUtils.isEmptyTrimmed((String)this.hostText.getText()) && !CommonUtils.isEmptyTrimmed((String)this.portText.getText());
        }
        return !CommonUtils.isEmptyTrimmed((String)this.urlText.getText());
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }

    public void loadSettings() {
        boolean showURL;
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            String defPort;
            String defHost;
            if (CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                defHost = "localhost";
                defPort = this.site.getDriver().getDefaultPort();
            } else {
                defHost = connectionInfo.getHostName();
                defPort = connectionInfo.getHostPort();
            }
            if (CommonUtils.isEmpty((String)defPort)) {
                defPort = String.valueOf(27017);
            }
            this.hostText.setText(defHost);
            this.portText.setText(defPort);
        }
        if (CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
            this.databaseNameText.setText("local");
        } else {
            this.databaseNameText.setText(connectionInfo.getDatabaseName());
        }
        super.loadSettings();
        String url = connectionInfo.getUrl();
        boolean bl = showURL = !CommonUtils.isEmpty((String)url);
        if (this.urlText != null && showURL) {
            this.urlText.setText(url);
        }
        this.typeURLRadio.setSelection(showURL);
        this.typeManualRadio.setSelection(!showURL);
        this.showTypeControls(showURL);
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        connectionInfo.setHostName(this.hostText.getText().trim());
        connectionInfo.setHostPort(this.portText.getText().trim());
        connectionInfo.setDatabaseName(this.databaseNameText.getText().trim());
        if (this.typeURLRadio.getSelection()) {
            connectionInfo.setConfigurationType(DBPDriverConfigurationType.URL);
        } else {
            connectionInfo.setConfigurationType(DBPDriverConfigurationType.MANUAL);
        }
        super.saveSettings(dataSource);
    }

    protected void saveConnectionURL(DBPConnectionConfiguration connectionInfo) {
        if (this.typeURLRadio.getSelection()) {
            connectionInfo.setUrl(this.urlText.getText().trim());
        } else {
            connectionInfo.setUrl("");
        }
    }

    @NotNull
    protected String getDefaultAuthModelId(DBPDataSourceContainer dataSource) {
        return "ferretdb_default";
    }

    private void createSettingsGroup(@NotNull Composite parent) {
        this.settingsGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        this.settingsGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        this.settingsGroup.setLayoutData((Object)gd);
    }

    private void createAddressGroup() {
        Group addressGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)MongoDBMessages.connection_page_group_address, (int)1, (int)768, (int)-1);
        this.createAddressType((Composite)addressGroup);
        this.createURlGroup((Composite)addressGroup);
        this.createSeedsGroup((Composite)addressGroup);
    }

    private void createAddressType(@NotNull Composite addressGroup) {
        Composite typeComposite = UIUtils.createComposite((Composite)addressGroup, (int)3);
        UIUtils.createControlLabel((Composite)typeComposite, (String)"Type");
        SelectionAdapter typeSwitcher = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FerretDBConnectionPage.this.showTypeControls((Boolean)e.widget.getData());
            }
        };
        this.typeManualRadio = UIUtils.createRadioButton((Composite)typeComposite, (String)"Manual", (Object)false, (SelectionListener)typeSwitcher);
        this.typeURLRadio = UIUtils.createRadioButton((Composite)typeComposite, (String)"URL", (Object)true, (SelectionListener)typeSwitcher);
    }

    private void createURlGroup(@NotNull Composite parent) {
        this.urlGroup = UIUtils.createComposite((Composite)parent, (int)2);
        this.urlGroup.setLayoutData((Object)new GridData(768));
        this.urlText = UIUtils.createLabelText((Composite)this.urlGroup, (String)"URL", (String)"");
        this.urlText.setLayoutData((Object)new GridData(768));
        UIUtils.setDefaultTextControlWidthHint((Control)this.urlText);
        this.urlText.addModifyListener(this.textListener);
        UIUtils.createEmptyLabel((Composite)this.urlGroup, (int)1, (int)1);
        UIUtils.createLabel((Composite)this.urlGroup, (String)"Do not put user name/password in the URL.\nURL must look like mongodb://parameters or mongodb+srv://parameters");
    }

    private void createSeedsGroup(@NotNull Composite parent) {
        this.seedsGroup = UIUtils.createComposite((Composite)parent, (int)2);
        this.seedsGroup.setLayoutData((Object)new GridData(768));
        this.hostText = UIUtils.createLabelText((Composite)this.seedsGroup, (String)"Host", (String)"");
        this.hostText.setLayoutData((Object)new GridData(768));
        UIUtils.setDefaultTextControlWidthHint((Control)this.hostText);
        this.hostText.addModifyListener(this.textListener);
        this.portText = UIUtils.createLabelText((Composite)this.seedsGroup, (String)"Port", (String)"");
        this.portText.setLayoutData((Object)new GridData(768));
        UIUtils.setDefaultTextControlWidthHint((Control)this.portText);
        this.portText.addModifyListener(this.textListener);
        this.databaseNameText = UIUtils.createLabelText((Composite)this.seedsGroup, (String)"Database", (String)"");
        this.databaseNameText.setLayoutData((Object)new GridData(768));
        UIUtils.setDefaultTextControlWidthHint((Control)this.databaseNameText);
        this.databaseNameText.addModifyListener(this.textListener);
    }

    private void showTypeControls(boolean showURL) {
        UIUtils.setControlVisible((Control)this.urlGroup, (boolean)showURL);
        UIUtils.setControlVisible((Control)this.seedsGroup, (!showURL ? 1 : 0) != 0);
        this.settingsGroup.layout(true, true);
        this.site.updateButtons();
    }
}

