/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client;

import com.influxdb.client.InfluxDBClient;
import com.influxdb.client.InfluxDBClientOptions;
import com.influxdb.client.domain.OnboardingRequest;
import com.influxdb.client.domain.OnboardingResponse;
import com.influxdb.client.domain.WriteConsistency;
import com.influxdb.client.internal.InfluxDBClientImpl;
import com.influxdb.utils.Arguments;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class InfluxDBClientFactory {
    private InfluxDBClientFactory() {
    }

    @Nonnull
    public static InfluxDBClient create() {
        InfluxDBClientOptions options = InfluxDBClientOptions.builder().loadProperties().build();
        return InfluxDBClientFactory.create(options);
    }

    @Nonnull
    public static InfluxDBClient create(@Nonnull String connectionString) {
        InfluxDBClientOptions options = InfluxDBClientOptions.builder().connectionString(connectionString).build();
        return InfluxDBClientFactory.create(options);
    }

    @Nonnull
    public static InfluxDBClient create(@Nonnull String url, @Nonnull String username, @Nonnull char[] password) {
        InfluxDBClientOptions options = InfluxDBClientOptions.builder().url(url).authenticate(username, password).build();
        return InfluxDBClientFactory.create(options);
    }

    @Nonnull
    public static InfluxDBClient create(@Nonnull String url, @Nonnull char[] token) {
        return InfluxDBClientFactory.create(url, token, null);
    }

    @Nonnull
    public static InfluxDBClient create(@Nonnull String url, @Nonnull char[] token, @Nullable String org) {
        return InfluxDBClientFactory.create(url, token, org, null);
    }

    @Nonnull
    public static InfluxDBClient create(@Nonnull String url, @Nonnull char[] token, @Nullable String org, @Nullable String bucket) {
        InfluxDBClientOptions options = InfluxDBClientOptions.builder().url(url).authenticateToken(token).org(org).bucket(bucket).build();
        return InfluxDBClientFactory.create(options);
    }

    @Nonnull
    public static InfluxDBClient createV1(@Nonnull String url, @Nullable String username, char[] password, @Nonnull String database, @Nullable String retentionPolicy) {
        return InfluxDBClientFactory.createV1(url, username, password, database, retentionPolicy, null);
    }

    @Nonnull
    public static InfluxDBClient createV1(@Nonnull String url, @Nullable String username, char[] password, @Nonnull String database, @Nullable String retentionPolicy, @Nullable WriteConsistency consistency) {
        Arguments.checkNonEmpty((String)database, (String)"database");
        InfluxDBClientOptions options = InfluxDBClientOptions.builder().url(url).org("-").authenticateToken(String.format("%s:%s", username == null ? "" : username, password == null ? "" : String.valueOf(password)).toCharArray()).bucket(String.format("%s/%s", database, retentionPolicy == null ? "" : retentionPolicy)).consistency(consistency).build();
        return InfluxDBClientFactory.create(options);
    }

    @Nonnull
    public static InfluxDBClient create(@Nonnull InfluxDBClientOptions options) {
        Arguments.checkNotNull((Object)options, (String)"InfluxDBClientOptions");
        return new InfluxDBClientImpl(options);
    }

    @Nonnull
    public static OnboardingResponse onBoarding(@Nonnull String url, @Nonnull String username, @Nonnull String password, @Nonnull String org, @Nonnull String bucket) {
        Arguments.checkNonEmpty((String)url, (String)"url");
        Arguments.checkNonEmpty((String)username, (String)"username");
        Arguments.checkNonEmpty((String)password, (String)"password");
        Arguments.checkNonEmpty((String)org, (String)"org");
        Arguments.checkNonEmpty((String)bucket, (String)"bucket");
        OnboardingRequest onboarding = new OnboardingRequest();
        onboarding.setUsername(username);
        onboarding.setPassword(password);
        onboarding.setOrg(org);
        onboarding.setBucket(bucket);
        return InfluxDBClientFactory.onBoarding(url, onboarding);
    }

    @Nonnull
    public static OnboardingResponse onBoarding(@Nonnull String url, @Nonnull OnboardingRequest onboarding) {
        Arguments.checkNonEmpty((String)url, (String)"url");
        Arguments.checkNotNull((Object)onboarding, (String)"onboarding");
        try (InfluxDBClientImpl client = new InfluxDBClientImpl(InfluxDBClientOptions.builder().url(url).build());){
            OnboardingResponse onboardingResponse = client.onBoarding(onboarding);
            return onboardingResponse;
        }
    }
}

