/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.bigtable.data;

import com.dbeaver.db.google.bigtable.BigTableUtils;
import com.dbeaver.db.google.bigtable.model.BigTableDataSource;
import com.dbeaver.db.google.bigtable.model.BigTableTable;
import com.dbeaver.model.document.data.DBAbstractDocument;
import com.dbeaver.model.document.data.DBMapValue;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.protobuf.ByteString;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.utils.CommonUtils;

public class BigTableDocument
extends DBAbstractDocument<BigTableDataSource, Row>
implements DBDValueCloneable {
    private static final Log log = Log.getLog(BigTableDocument.class);
    @Nullable
    private BigTableTable table;

    public BigTableDocument(@NotNull BigTableDataSource dataSource, @Nullable BigTableTable table, Row row) {
        super((DBPDataSource)dataSource, (Object)row);
        this.table = table;
    }

    @Nullable
    public Object getDocumentId() {
        return ((Row)this.rawValue).getKey().toStringUtf8();
    }

    public Object getDocumentProperty(String name) {
        switch (name) {
            case "id": {
                return this.getDocumentId();
            }
        }
        return null;
    }

    @NotNull
    public String getDocumentContentType() {
        return "text/json";
    }

    protected DBMapValue<BigTableDataSource> makeRawMap() {
        return BigTableUtils.makeRawMap((BigTableDataSource)this.dataSource, this, (Row)this.rawValue);
    }

    public void serializeDocument(@NotNull DBRProgressMonitor monitor, @NotNull Writer writer) {
        ((BigTableDataSource)this.dataSource).serializeDocument((Row)this.getRawValue(), writer);
    }

    public void updateDocument(@NotNull DBRProgressMonitor monitor, @NotNull Reader reader) {
        this.rawMap = new DBMapValue((DBPDataSource)((BigTableDataSource)this.dataSource), (Object)this, ((BigTableDataSource)this.dataSource).deserializeDocument(reader));
        this.rawValue = ((BigTableDataSource)this.dataSource).convertMapToNativeDocument((DBMapValue<BigTableDataSource>)this.rawMap);
    }

    public BigTableDocument copy() {
        return new BigTableDocument((BigTableDataSource)this.dataSource, this.table, (Row)this.rawValue);
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) throws DBCException {
        return this.copy();
    }

    @NotNull
    public DBSAttributeBase[] getAttributes() {
        List cells = ((Row)this.rawValue).getCells();
        ArrayList<DocumentAttribute> attrs = new ArrayList<DocumentAttribute>();
        attrs.add(new DocumentAttributeRowKey());
        int cfIndex = 1;
        for (RowCell cell : cells) {
            DocumentAttributeColumnFamily cfAttr = null;
            for (DocumentAttribute attr : attrs) {
                if (!(attr instanceof DocumentAttributeColumnFamily) || !attr.getName().equals(cell.getFamily())) continue;
                cfAttr = (DocumentAttributeColumnFamily)attr;
                break;
            }
            if (cfAttr != null) continue;
            cfAttr = new DocumentAttributeColumnFamily(cfIndex++, cell.getFamily());
            attrs.add(cfAttr);
        }
        return attrs.toArray(new DBSAttributeBase[0]);
    }

    public Object getAttributeValue(@NotNull DBSAttributeBase attribute) throws DBCException {
        if (attribute instanceof DocumentAttributeRowKey) {
            return ((Row)this.rawValue).getKey().toStringUtf8();
        }
        if (attribute instanceof DocumentAttributeColumnFamily) {
            LinkedHashMap<String, String> cfMap = new LinkedHashMap<String, String>();
            for (RowCell cell : ((Row)this.rawValue).getCells(attribute.getName())) {
                cfMap.put(cell.getQualifier().toStringUtf8(), cell.getValue().toStringUtf8());
            }
            return new DBMapValue((DBPDataSource)((BigTableDataSource)this.dataSource), (Object)this, cfMap);
        }
        if (attribute instanceof DocumentAttributeCell) {
            List cfCells = ((Row)this.rawValue).getCells(((DocumentAttributeCell)attribute).getColumnFamily().getName(), attribute.getName());
            if (cfCells.isEmpty()) {
                return null;
            }
            return ((RowCell)cfCells.get(0)).getValue().toStringUtf8();
        }
        log.debug((Object)("Wrong attribute: " + String.valueOf(attribute)));
        return null;
    }

    public static class ByteStringJsonConverter
    implements JsonSerializer<ByteString>,
    JsonDeserializer<ByteString> {
        public JsonElement serialize(ByteString src, Type srcType, JsonSerializationContext context) {
            return new JsonPrimitive(src.toStringUtf8());
        }

        public ByteString deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return null;
        }
    }

    protected static class DocumentAttribute
    implements DBSAttributeBase {
        private int position;
        private String name;
        private DBPDataKind dataKind;

        public DocumentAttribute(int position, String name) {
            this(position, name, DBPDataKind.OBJECT);
        }

        public DocumentAttribute(int position, String name, DBPDataKind dataKind) {
            this.position = position;
            this.name = name;
            this.dataKind = dataKind;
        }

        @Property(viewable=true, order=1)
        @NotNull
        public String getName() {
            return this.name;
        }

        @Property(viewable=true, order=2)
        public int getOrdinalPosition() {
            return this.position;
        }

        @Property(viewable=true, order=3)
        @NotNull
        public String getTypeName() {
            return this.dataKind.name();
        }

        @NotNull
        public String getFullTypeName() {
            return this.dataKind.name();
        }

        public int getTypeID() {
            return this.dataKind.ordinal();
        }

        @NotNull
        public DBPDataKind getDataKind() {
            return this.dataKind;
        }

        @Nullable
        public Integer getScale() {
            return null;
        }

        @Nullable
        public Integer getPrecision() {
            return null;
        }

        public long getMaxLength() {
            return 0L;
        }

        public long getTypeModifiers() {
            return 0L;
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isAutoGenerated() {
            return false;
        }

        public String toString() {
            return this.getName() + "; " + this.getOrdinalPosition();
        }
    }

    private static class DocumentAttributeCell
    extends DocumentAttribute {
        DocumentAttributeColumnFamily cf;

        public DocumentAttributeCell(DocumentAttributeColumnFamily cf, int index, String name) {
            super(index, name, DBPDataKind.OBJECT);
            this.cf = cf;
        }

        DocumentAttributeColumnFamily getColumnFamily() {
            return this.cf;
        }
    }

    private static class DocumentAttributeColumnFamily
    extends DocumentAttribute {
        DocumentAttributeColumnFamily(int index, String name) {
            super(index, name, DBPDataKind.DOCUMENT);
        }
    }

    private static class DocumentAttributeRowKey
    extends DocumentAttribute {
        DocumentAttributeRowKey() {
            super(0, "RowKey");
        }
    }

    public static class RowCellJsonConverter
    implements JsonSerializer<RowCell>,
    JsonDeserializer<RowCell> {
        public JsonElement serialize(RowCell src, Type srcType, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("family", src.getFamily());
            jsonObject.addProperty("qualifier", src.getQualifier().toStringUtf8());
            if (!CommonUtils.isEmpty((Collection)src.getLabels())) {
                JsonArray labelsArray = new JsonArray();
                for (String label : src.getLabels()) {
                    labelsArray.add(label);
                }
                jsonObject.add("labels", (JsonElement)labelsArray);
            }
            jsonObject.addProperty("value", src.getValue().toStringUtf8());
            return jsonObject;
        }

        public RowCell deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return null;
        }
    }
}

