/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.bigtable;

import com.dbeaver.db.google.bigtable.model.BigTableDataSource;
import com.google.cloud.bigtable.data.v2.models.Filters;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import net.sf.jsqlparser.schema.Column;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.utils.CommonUtils;

public class BigTableSQL {
    public static Filters.Filter createQueryFilter(BigTableDataSource dataSource, String condition) throws DBCException {
        Expression newExpression = SQLSemanticProcessor.parseCondExpression((String)condition);
        Filters.ChainFilter filter = Filters.FILTERS.chain();
        if (BigTableSQL.parseExpression(filter, newExpression)) {
            return filter;
        }
        return null;
    }

    public static boolean parseExpression(Filters.ChainFilter chainFilter, Expression expr) throws DBCException {
        ParenthesedExpressionList parenthesis;
        if (expr instanceof AndExpression) {
            return BigTableSQL.parseExpression(chainFilter, ((AndExpression)expr).getLeftExpression()) && BigTableSQL.parseExpression(chainFilter, ((AndExpression)expr).getRightExpression());
        }
        if (expr instanceof InExpression) {
            throw new DBCException("IN conditions not supported: " + String.valueOf(expr));
        }
        if (expr instanceof OrExpression) {
            throw new DBCException("OR conditions not supported: " + String.valueOf(expr));
        }
        if (expr instanceof BinaryExpression) {
            return BigTableSQL.parseBinaryExpression(chainFilter, (BinaryExpression)expr);
        }
        if (expr instanceof ParenthesedExpressionList && (parenthesis = (ParenthesedExpressionList)expr).size() == 1) {
            return BigTableSQL.parseExpression(chainFilter, (Expression)parenthesis.get(0));
        }
        throw new DBCException("Unsupported expression: " + String.valueOf(expr));
    }

    private static boolean parseBinaryExpression(Filters.ChainFilter chainFilter, BinaryExpression expr) throws DBCException {
        boolean regex;
        Expression left = expr.getLeftExpression();
        if (!(left instanceof Column)) {
            throw new DBCException("Unsupported left operand: " + String.valueOf(left));
        }
        Column column = (Column)left;
        String fieldName = BigTableSQL.unquote(column.getFullyQualifiedName());
        Object fieldValue = BigTableSQL.parseValueExpression(expr.getRightExpression());
        if (expr instanceof EqualsTo) {
            regex = false;
        } else if (expr instanceof RegExpMatchOperator) {
            regex = true;
        } else {
            throw new DBCException("Unsupported condition operator: " + String.valueOf(expr));
        }
        BigTableSQL.makeObjectCondition(chainFilter, fieldName, fieldValue, regex);
        return true;
    }

    private static void makeObjectCondition(Filters.ChainFilter chainFilter, String fieldName, Object fieldValue, boolean regex) {
        String strValue = CommonUtils.toString((Object)fieldValue);
        if ("RowKey".equalsIgnoreCase(fieldName)) {
            chainFilter.filter(regex ? Filters.FILTERS.key().regex(strValue) : Filters.FILTERS.key().exactMatch(strValue));
        } else {
            chainFilter.filter(regex ? Filters.FILTERS.value().regex(strValue) : Filters.FILTERS.value().exactMatch(strValue));
        }
    }

    private static Object parseValueExpression(Expression expr) throws DBCException {
        if (expr instanceof StringValue) {
            return ((StringValue)expr).getValue();
        }
        if (expr instanceof LongValue) {
            return ((LongValue)expr).getValue();
        }
        if (expr instanceof DoubleValue) {
            return ((DoubleValue)expr).getValue();
        }
        if (expr instanceof TimestampValue) {
            return ((TimestampValue)expr).getValue();
        }
        if (expr instanceof TimeValue) {
            return ((TimeValue)expr).getValue();
        }
        if (expr instanceof DateValue) {
            return ((DateValue)expr).getValue();
        }
        if (expr instanceof Column) {
            String literal = BigTableSQL.unquote(((Column)expr).getFullyQualifiedName());
            if (literal.equals("true") || literal.equals("false")) {
                return Boolean.valueOf(literal);
            }
            throw new DBCException("Unexpected literal: " + String.valueOf(expr));
        }
        throw new DBCException("Unsupported value: " + String.valueOf(expr));
    }

    public static String unquote(String name) {
        return name.replace("\"", "");
    }
}

