/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.CharSet;
import com.ingres.gcf.util.SqlChar;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.SqlLongNCharCache;
import com.ingres.gcf.util.SqlVarChar;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.SQLException;

public class SqlLongCharCache
extends SqlLongNCharCache {
    private CharSet charSet = null;

    public SqlLongCharCache(CharSet charSet) {
        this.charSet = charSet;
    }

    public SqlLongCharCache(CharSet charSet, int n) {
        super(n);
        this.charSet = charSet;
    }

    public void set(InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.setNull();
        } else {
            this.set(this.cnvtIS2Rdr(inputStream));
        }
    }

    public void set(SqlChar sqlChar) throws SQLException {
        if (sqlChar == null || sqlChar.isNull()) {
            this.setNull();
        } else {
            sqlChar.extend();
            this.set(this.cnvtIS2Rdr(SqlLongCharCache.getBinary(sqlChar.value, 0, sqlChar.length)));
        }
    }

    public void set(SqlVarChar sqlVarChar) throws SQLException {
        if (sqlVarChar == null || sqlVarChar.isNull()) {
            this.setNull();
        } else {
            this.set(this.cnvtIS2Rdr(SqlLongCharCache.getBinary(sqlVarChar.value, 0, sqlVarChar.length)));
        }
    }

    public void get(OutputStream outputStream) throws SQLException {
        this.get(this.cnvtOS2Wtr(outputStream));
    }

    @Override
    public byte[] getBytes() throws SQLException {
        byte[] byArray;
        try {
            byArray = this.charSet.getBytes(this.getString().toCharArray());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
        }
        return byArray;
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        byte[] byArray;
        try {
            byArray = this.charSet.getBytes(this.getString(n).toCharArray());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
        }
        return byArray;
    }

    private Reader cnvtIS2Rdr(InputStream inputStream) throws SQLException {
        try {
            return this.charSet.getISR(inputStream);
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
        }
    }

    private Writer cnvtOS2Wtr(OutputStream outputStream) throws SQLException {
        try {
            return this.charSet.getOSW(outputStream);
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
        }
    }
}

