/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.dam;

import com.ingres.gcf.dam.MsgIn;
import com.ingres.gcf.dam.OutBuff;
import com.ingres.gcf.dam.TlConst;
import com.ingres.gcf.util.CompatCI;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.TraceLog;
import java.sql.SQLException;
import java.util.Random;

public class MsgConn
extends MsgIn
implements TlConst,
GcfErr {
    private OutBuff cncl = null;
    private boolean lock_active = false;
    private Thread lock_thread = null;
    private Object lock_obj = new Object();
    private static byte[] KS = new byte[384];
    private static byte[] kbuff = new byte[8];
    private static Random rand = new Random(System.currentTimeMillis());

    public MsgConn(String string, byte[][] byArray, TraceLog traceLog) throws SQLException {
        super(traceLog);
        String[][] stringArray;
        this.title = "Msg[" + this.connID() + "]";
        SQLException sQLException = null;
        try {
            stringArray = this.getTargets(string);
        }
        catch (SQLException sQLException2) {
            throw sQLException2;
        }
        catch (Exception exception) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": URL parsing error - " + exception.getMessage());
            }
            throw SqlExFactory.get(ERR_GC4000_BAD_URL, exception);
        }
        MsgConn.randomSort((Object[])stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.connect(stringArray[i][0], stringArray[i][1]);
                this.sendCR(byArray[0]);
                byArray[0] = this.recvCC();
                return;
            }
            catch (SQLException sQLException3) {
                sQLException = sQLException3;
                continue;
            }
        }
        throw sQLException != null ? sQLException : SqlExFactory.get(ERR_GC4000_BAD_URL);
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disconnect() {
        if (this.cncl != null) {
            try {
                this.cncl.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.cncl = null;
            }
        }
        super.disconnect();
    }

    @Override
    public synchronized void close() {
        if (!this.isClosed()) {
            super.close();
            this.disconnect();
        }
    }

    public synchronized void cancel() throws SQLException {
        if (this.cncl == null) {
            try {
                this.cncl = new OutBuff(this.socket.getOutputStream(), this.connID(), 16, this.trace.getTraceLog());
                this.cncl.setProtoLvl(this.tl_proto_lvl);
            }
            catch (Exception exception) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": error creating cancel buffer: " + exception.getMessage());
                }
                this.disconnect();
                throw SqlExFactory.get(ERR_GC4001_CONNECT_ERR, exception);
            }
        }
        try {
            if (this.trace.enabled(2)) {
                this.trace.write(this.title + ": interrupt network connection");
            }
            this.cncl.begin((short)21065, 0);
            this.cncl.send(true);
        }
        catch (SQLException sQLException) {
            this.disconnect();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked(boolean bl) {
        boolean bl2 = false;
        Object object = this.lock_obj;
        synchronized (object) {
            if (this.lock_active) {
                bl2 = bl ? true : this.lock_thread == Thread.currentThread();
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws SQLException {
        Object object = this.lock_obj;
        synchronized (object) {
            while (this.lock_active) {
                if (this.lock_thread == Thread.currentThread()) {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.title + ".lock(): connection locked by " + Thread.currentThread());
                    }
                    throw SqlExFactory.get(ERR_GC4005_SEQUENCING);
                }
                try {
                    this.lock_obj.wait();
                }
                catch (Exception exception) {}
            }
            this.lock_thread = Thread.currentThread();
            this.lock_active = true;
            if (this.trace.enabled(5)) {
                this.trace.write(this.title + ".lock(): owner " + this.lock_thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        Object object = this.lock_obj;
        synchronized (object) {
            if (this.lock_thread == null || !this.lock_active) {
                if (this.trace.enabled(5)) {
                    this.trace.write(this.title + ".unlock(): conn not locked!");
                }
                this.lock_thread = null;
                this.lock_active = false;
            } else {
                if (this.trace.enabled(5)) {
                    this.trace.write(this.title + ".unlock(): owner " + this.lock_thread);
                    if (this.lock_thread != Thread.currentThread()) {
                        this.trace.write(this.title + ".unlock(): current thread " + Thread.currentThread());
                    }
                }
                this.lock_active = false;
                this.lock_thread = null;
                this.lock_obj.notify();
            }
        }
    }

    public byte[] encode(String string, byte[] byArray, String string2) throws SQLException {
        byte[] byArray2;
        try {
            byArray2 = MsgConn.encode(this.char_set.getBytes(string), byArray, this.char_set.getBytes(string2));
        }
        catch (Exception exception) {
            throw SqlExFactory.get(ERR_GC401E_CHAR_ENCODE);
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encode(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = null;
        byte[] byArray5 = KS;
        synchronized (KS) {
            int n;
            int n2 = 0;
            for (n = 0; n < 8; ++n) {
                if (n2 >= byArray.length) {
                    n2 = 0;
                }
                MsgConn.kbuff[n] = (byte)(byArray[n2++] ^ (byArray2 != null ? byArray2[n] : (byte)0));
            }
            CompatCI.setkey(kbuff, KS);
            int n3 = byArray3.length / 7 + 1;
            byArray4 = new byte[n3 * 8];
            n2 = 0;
            n = 0;
            for (int i = 0; i < n3; ++i) {
                byArray4[n++] = (byte)rand.nextInt(256);
                for (int j = 1; j < 8; ++j) {
                    if (n2 < byArray3.length) {
                        byArray4[n++] = byArray3[n2++];
                        continue;
                    }
                    if (n2 > byArray3.length) {
                        byArray4[n++] = (byte)rand.nextInt(256);
                        continue;
                    }
                    byArray4[n++] = 0;
                    ++n2;
                }
            }
            CompatCI.encode(byArray4, 0, byArray4.length, KS, byArray4, 0);
            // ** MonitorExit[var9_4] (shouldn't be in output)
            return byArray4;
        }
    }

    private String[][] getTargets(String string) throws SQLException {
        String[] stringArray;
        String[] stringArray2 = this.parseList(string, ';');
        Object[][] objectArrayArray = new Object[stringArray2.length][];
        int n = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            String string2 = this.getHost(stringArray2[i]);
            stringArray = this.getPort(stringArray2[i]);
            objectArrayArray[i] = new Object[2];
            objectArrayArray[i][0] = string2;
            objectArrayArray[i][1] = stringArray;
            n += stringArray.length;
        }
        String[][] stringArray3 = new String[n][];
        n = 0;
        for (int i = 0; i < objectArrayArray.length; ++i) {
            stringArray = (String[])objectArrayArray[i][1];
            for (int j = 0; j < stringArray.length; ++j) {
                stringArray3[n] = new String[2];
                stringArray3[n][0] = (String)objectArrayArray[i][0];
                stringArray3[n][1] = stringArray[j];
                ++n;
            }
        }
        return stringArray3;
    }

    private String getHost(String string) throws SQLException {
        int n;
        int n2 = 0;
        if (string.startsWith("[")) {
            n = string.indexOf(93);
            if (n < 0) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": right bracket ']' missing " + "in IPv6 address '" + string + "'");
                }
                throw SqlExFactory.get(ERR_GC4000_BAD_URL);
            }
            n2 = 1;
        } else {
            n = string.indexOf(58);
        }
        return n < 0 ? string : string.substring(n2, n);
    }

    private String[] getPort(String string) throws SQLException {
        int n = 0;
        if (string.startsWith("[") && (n = string.indexOf(93)) < 0) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": right bracket ']' missing " + "in IPv6 address '" + string + "'");
            }
            throw SqlExFactory.get(ERR_GC4000_BAD_URL);
        }
        if ((n = string.indexOf(58, n)) < 0) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": port ID missing '" + string + "'");
            }
            throw SqlExFactory.get(ERR_GC4000_BAD_URL);
        }
        return this.parseList(string, ',', n + 1, 0);
    }

    private String[] parseList(String string, char c) {
        return this.parseList(string, c, 0, 0);
    }

    private String[] parseList(String string, char c, int n, int n2) {
        String[] stringArray;
        if (n >= string.length()) {
            stringArray = new String[n2];
        } else {
            int n3 = string.indexOf(c, n);
            if (n3 >= 0) {
                if (n3 - n <= 1) {
                    stringArray = this.parseList(string, c, n3 + 1, n2);
                } else {
                    stringArray = this.parseList(string, c, n3 + 1, n2 + 1);
                    stringArray[n2] = string.substring(n, n3);
                }
            } else {
                stringArray = new String[n2 + 1];
                stringArray[n2] = n > 0 ? string.substring(n) : string;
            }
        }
        return stringArray;
    }

    private static void randomSort(Object[] objectArray) {
        switch (objectArray.length) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                Random random = new Random();
                if (!random.nextBoolean()) break;
                Object object = objectArray[0];
                objectArray[0] = objectArray[1];
                objectArray[1] = object;
                break;
            }
            default: {
                Random random = new Random();
                for (int i = 0; i < objectArray.length; ++i) {
                    int n = random.nextInt(objectArray.length);
                    if (i == n) continue;
                    Object object = objectArray[i];
                    objectArray[i] = objectArray[n];
                    objectArray[n] = object;
                }
            }
        }
    }
}

