/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.prompt;

import com.dbeaver.model.ai.AIUtilsPro;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.ai.AIDatabaseScope;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.engine.AIDatabaseContext;
import org.jkiss.dbeaver.model.ai.impl.AIPromptUtils;
import org.jkiss.dbeaver.model.ai.prompt.AIPromptAbstract;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSourceSupplier;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityElement;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.utils.CommonUtils;

public class AIPromptObjectDescribe
extends AIPromptAbstract {
    private static final Log log = Log.getLog(AIPromptObjectDescribe.class);
    public static final String[] DESCRIBE_SCHEMA_INSTRUCTIONS = new String[0];
    public static final String[] DESCRIBE_SCHEMA_GOALS = new String[]{"Help users to understand the purpose of database schema.", "Provide information about schema tables, columns, schemas, procedures, etc.", "Do not describe each object individually, give a general description."};
    public static final String[] DESCRIBE_GENERIC_GOALS = new String[]{"Help users to explain database schema objects.", "Provide information about database objects such as tables, columns, schemas, procedures, etc."};
    public static final String[] DESCRIBE_TABLE_GOALS = new String[]{"Help users to understand purpose of the table in the database.", "Provide information about columns and data types only if it is important.", "Use readTableSampleRows function if you need information about the actual data."};
    public static final String[] DESCRIBE_TABLES_GOALS = new String[]{"Help users to understand purpose of specified tables in the database.", "Provide information about columns and data types only if it is important.", "Use readTableSampleRows function if you need information about the actual data."};

    public static AIMessage createDescribeMessage(@NotNull List<DBSObject> dbsObjects) {
        String objectNames = dbsObjects.stream().map(o -> AIUtilsPro.getDatabaseObjectInfo(o, true)).collect(Collectors.joining(", "));
        String uiMessage = "Describe " + objectNames;
        String goal = dbsObjects.size() == 1 ? "Briefly describe " + objectNames + "." : "Briefly describe following objects and how they connected with each other: " + objectNames + ".";
        return AIMessage.userAutoMessage((String)goal, (String)uiMessage);
    }

    @NotNull
    public static AIDatabaseContext createDatabaseContext(@NotNull DBRProgressMonitor monitor, @NotNull List<DBSObject> dbsObjects) throws DBException {
        if (dbsObjects.isEmpty()) {
            throw new DBException("Empty list of objects");
        }
        DBSObject firstObject = dbsObjects.getFirst();
        DBPDataSource dataSource = firstObject.getDataSource();
        if (dataSource == null) {
            throw new DBException("Object '" + String.valueOf(firstObject) + "' is not connected");
        }
        int i = 1;
        while (i < dbsObjects.size()) {
            if (dbsObjects.get(i).getDataSource() != dataSource) {
                throw new DBException("Object from different data sources cannot be described together");
            }
            if (dbsObjects.get(i).getClass() != firstObject.getClass()) {
                throw new DBException("Object of different types cannot be described together");
            }
            ++i;
        }
        LinkedHashSet allEntities = new LinkedHashSet();
        for (DBSObject dbsObject : dbsObjects) {
            List dbsEntities = new ArrayList();
            String objectDDL = AIUtils.getObjectDDL((DBSObject)dbsObject, (DBRProgressMonitor)monitor);
            if (dbsObject instanceof DataSourceDescriptor) {
                dbsEntities = DBStructUtils.getRelatedDBSEntities((DBRProgressMonitor)monitor, (DBSObject)dbsObject);
            } else if (dbsObject instanceof DBSObjectContainer) {
                dbsEntities = DBStructUtils.getRelatedDBSEntities((DBRProgressMonitor)monitor, (DBSObject)dbsObject);
            } else if ((objectDDL != null || dbsObject instanceof DBSEntity) && dbsObject.getParentObject() != null) {
                dbsEntities = DBStructUtils.getRelatedDBSEntities((DBRProgressMonitor)monitor, (DBSObject)dbsObject.getParentObject());
            } else if (dbsObject instanceof DBSEntityElement) {
                dbsEntities = DBStructUtils.getRelatedDBSEntities((DBRProgressMonitor)monitor, (DBSObject)dbsObject.getParentObject());
            }
            allEntities.addAll(dbsEntities);
        }
        AIDatabaseScope scope = !allEntities.isEmpty() ? AIDatabaseScope.CUSTOM : AIDatabaseScope.CURRENT_DATASOURCE;
        DBSLogicalDataSource logicalDataSource = new DBSLogicalDataSource(dataSource.getContainer());
        logicalDataSource.setCurrentSchema(DBStructUtils.getObjectSchema((DBSObject)firstObject));
        logicalDataSource.setCurrentCatalog(DBStructUtils.getObjectCatalog((DBSObject)firstObject));
        AIDatabaseContext.Builder contextBuilder = new AIDatabaseContext.Builder(logicalDataSource).setScope(scope);
        if (!CommonUtils.isEmpty(allEntities)) {
            contextBuilder.setCustomEntities(new ArrayList(allEntities));
        }
        DBCExecutionContext defaultContext = DBUtils.getDefaultContext((DBSObject)firstObject, (boolean)true);
        return contextBuilder.setExecutionContext(defaultContext).build();
    }

    @NotNull
    public String generatorId() {
        return "object-describe";
    }

    @NotNull
    public static AIPromptObjectDescribe create(@NotNull DBSLogicalDataSourceSupplier dataSource) {
        return AIPromptObjectDescribe.create(dataSource, null);
    }

    @NotNull
    public static AIPromptObjectDescribe create(@NotNull DBSLogicalDataSourceSupplier dataSource, @Nullable List<DBSObject> dbsObjects) {
        AIPromptObjectDescribe builder = new AIPromptObjectDescribe();
        DBSLogicalDataSource logicalDataSource = (DBSLogicalDataSource)dataSource.get();
        if (logicalDataSource != null) {
            builder.addContexts(AIPromptUtils.describeDataSourceInfo((DBSLogicalDataSource)logicalDataSource));
        } else {
            log.error((Object)"No datasource info was passed to object describe");
        }
        ArrayList instructions = new ArrayList();
        AIPromptUtils.addGeneralRulesInstructions((DBSLogicalDataSource)logicalDataSource, instructions);
        if (dbsObjects != null && !dbsObjects.isEmpty()) {
            DBSObject dbsObject = dbsObjects.getFirst();
            if (dbsObject instanceof DBSObjectContainer) {
                Collections.addAll(instructions, DESCRIBE_SCHEMA_INSTRUCTIONS);
            }
            builder.addInstructions(instructions.toArray(new String[0]));
            if (dbsObject instanceof DBSObjectContainer) {
                builder.addGoals(DESCRIBE_SCHEMA_GOALS);
            } else if (dbsObject instanceof DBSEntity) {
                builder.addGoals(dbsObjects.size() == 1 ? DESCRIBE_TABLE_GOALS : DESCRIBE_TABLES_GOALS);
            } else {
                builder.addGoals(DESCRIBE_GENERIC_GOALS);
            }
        } else {
            builder.addGoals(DESCRIBE_GENERIC_GOALS);
        }
        return builder;
    }
}

