/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.prompt;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.impl.AIPromptUtils;
import org.jkiss.dbeaver.model.ai.prompt.AIPromptAbstract;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSourceSupplier;

public class AIPromptExplainSqlQuery
extends AIPromptAbstract {
    public static final String[] SQL_EXPLAIN_GOALS = new String[]{"Help users to explain SQL queries.", "Provide information about tables involved in query."};

    @NotNull
    public static AIMessage createExplainQueryMessage(@NotNull String query) {
        String prompt = "Explain the following query:\n```\n%s\n```".formatted(query);
        return AIMessage.userAutoMessage((String)(prompt + "\nProvide some basic overview, but without going into fine details."), (String)prompt);
    }

    @NotNull
    public String generatorId() {
        return "sql-explain";
    }

    @NotNull
    public static AIPromptExplainSqlQuery create(@NotNull DBSLogicalDataSourceSupplier dsSupplier) {
        AIPromptExplainSqlQuery builder = new AIPromptExplainSqlQuery();
        DBSLogicalDataSource dataSource = (DBSLogicalDataSource)dsSupplier.get();
        if (dataSource != null) {
            builder.addContexts(AIPromptUtils.describeDataSourceInfo((DBSLogicalDataSource)dataSource)).addInstructions(AIPromptUtils.createGenerateQueryInstructions((DBSLogicalDataSource)dataSource));
        }
        builder.addGoals(SQL_EXPLAIN_GOALS);
        return builder;
    }
}

