/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.functions;

import com.dbeaver.model.ai.AIUtilsPro;
import com.dbeaver.model.ai.impl.SampleDataProvider;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AIFunction;
import org.jkiss.dbeaver.model.ai.AIFunctionContext;
import org.jkiss.dbeaver.model.ai.AIFunctionResult;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.utils.CommonUtils;

public class AIFunctionReadTableSampleRows
implements AIFunction {
    private static final Log log = Log.getLog(AIFunctionReadTableSampleRows.class);
    public static final int DEFAULT_SAMPLE_DATA_ROW_COUNT = 10;
    public static final int MAX_SAMPLE_DATA_ROWS_COUNT = 20;
    public static final String PARAM_TABLE = "table";
    public static final String PARAM_LIMIT = "rowCount";

    @NotNull
    public AIFunctionResult callFunction(@NotNull AIFunctionContext context, @NotNull Map<String, Object> parameters) throws DBException {
        String sample;
        String tableName = JSONUtils.getString(parameters, (String)PARAM_TABLE);
        if (CommonUtils.isEmpty((String)tableName)) {
            throw new DBException("Table name is missing");
        }
        int rowCount = CommonUtils.toInt((Object)parameters.get(PARAM_LIMIT), (int)10);
        if (rowCount > 20 || rowCount < 1) {
            rowCount = 10;
        }
        try {
            DBSDataContainer table = AIUtilsPro.findTableInContext(context, tableName);
            sample = new SampleDataProvider().getSampleData(context.getMonitor(), table, rowCount);
        }
        catch (DBException dBException) {
            log.error((Object)"Error reading table data");
            sample = "N/A";
        }
        return new AIFunctionResult(AIFunctionResult.FunctionType.INFORMATION, "Table '" + tableName + " sample data is: " + sample);
    }
}

