/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.engine.openai;

import com.dbeaver.model.ai.audio.AIAudioStream;
import com.dbeaver.model.ai.audio.AIEngineAudio;
import com.dbeaver.model.ai.audio.AITranscriptResult;
import com.dbeaver.model.ai.engine.openai.OpenAIBaseProProperties;
import com.dbeaver.model.ai.engine.openai.OpenAITranscriber;
import com.dbeaver.model.ai.engine.openai.client.OpenAIClientPro;
import com.dbeaver.model.ai.rag.AIEmbeddingGenerator;
import com.dbeaver.model.ai.rag.AIVectorEmbedding;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIClient;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIEngine;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIRequestFilter;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class OpenAIEnginePro<PROPERTIES extends OpenAIBaseProProperties>
extends OpenAIEngine<PROPERTIES>
implements AIEngineAudio,
AIEmbeddingGenerator {
    public OpenAIEnginePro(@NotNull PROPERTIES properties) {
        super(properties);
    }

    @NotNull
    public List<AIVectorEmbedding> embedTexts(@NotNull DBRProgressMonitor monitor, @NotNull List<String> texts) throws DBException {
        OpenAIClient openAIClient = (OpenAIClient)this.openAiService.getInstance();
        if (openAIClient instanceof OpenAIClientPro) {
            OpenAIClientPro clientPro = (OpenAIClientPro)openAIClient;
            return clientPro.embedTexts(monitor, texts, ((OpenAIBaseProProperties)this.properties).getEmbeddingModel(), ((OpenAIBaseProProperties)this.properties).getEmbeddingDimension()).stream().map(AIVectorEmbedding::new).toList();
        }
        throw new DBException("Current OpenAI Client doesn't support embeddings");
    }

    @NotNull
    public String getEmbeddingModelName() {
        return ((OpenAIBaseProProperties)this.properties).getEmbeddingModel();
    }

    public boolean isLoggingEnabled() {
        return ((OpenAIBaseProProperties)this.properties).isLoggingEnabled();
    }

    @Override
    @NotNull
    public AITranscriptResult createSpeechTranscription(@NotNull AIAudioStream audio) throws DBException {
        try {
            return this.createTranscriber().transcribe(audio).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DBException("Transcription was interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new DBException("Error transcribing audio: " + e.getMessage(), (Throwable)e);
        }
    }

    protected OpenAITranscriber<OpenAIBaseProProperties> createTranscriber() throws DBException {
        return new OpenAITranscriber<OpenAIBaseProProperties>(this.createClient(), (OpenAIBaseProProperties)this.properties);
    }

    @NotNull
    protected OpenAIClient createClient() throws DBException {
        if (((OpenAIBaseProProperties)this.properties).isLegacyApi()) {
            return super.createClient();
        }
        String token = ((OpenAIBaseProProperties)this.properties).getToken();
        if (token == null || token.isEmpty()) {
            throw new DBException("OpenAI API token is not set");
        }
        String baseUrl = ((OpenAIBaseProProperties)this.properties).getBaseUrl();
        if (baseUrl == null || baseUrl.isEmpty()) {
            baseUrl = "https://api.openai.com/v1/";
        }
        return new OpenAIClientPro(baseUrl, List.of(new OpenAIRequestFilter(token)));
    }
}

