/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.engine.gemini.dto;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.registry.AIFunctionDescriptor;

public record GeminiFunction(String name, String description, Parameters parameters) {
    public static final String TYPE_OBJECT = "object";

    public GeminiFunction(@NotNull AIFunctionDescriptor function) {
        this(function.getId(), function.getDescription(), new Parameters(GeminiFunction.createInputSchemaProperties(function), (String[])Arrays.stream(function.getParameters()).filter(AIFunctionDescriptor.Parameter::isRequired).map(AIFunctionDescriptor.Parameter::getName).toArray(String[]::new), TYPE_OBJECT));
    }

    @NotNull
    private static Map<String, Parameters.Property> createInputSchemaProperties(@NotNull AIFunctionDescriptor function) {
        LinkedHashMap<String, Parameters.Property> propertyMap = new LinkedHashMap<String, Parameters.Property>();
        AIFunctionDescriptor.Parameter[] parameterArray = function.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            AIFunctionDescriptor.Parameter param = parameterArray[n2];
            Parameters.Property property = new Parameters.Property(param.getType(), param.getDescription(), param.getValidValues());
            propertyMap.put(param.getName(), property);
            ++n2;
        }
        return propertyMap;
    }

    public record Parameters(Map<String, Property> properties, String[] required, String type) {

        public record Property(String type, String description, @SerializedName(value="enum") String[] enumValues) {
        }
    }
}

