/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.engine.gemini;

import com.google.gson.annotations.SerializedName;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.utils.CommonUtils;

public class GeminiProperties
implements AIEngineProperties {
    private static final String GEMINI_TOKEN = "gemini.token";
    private static final String GPT_MODEL_TEMPERATURE = "gpt.model.temperature";
    private static final String GPT_LOG_QUERY = "gpt.log.query";
    private static final String GEMINI_MODEL = "gemini.model";
    @SecureProperty
    @SerializedName(value="gemini.token")
    private String token;
    @SerializedName(value="gpt.model.temperature")
    private double temperature;
    @SerializedName(value="gpt.log.query")
    private boolean loggingEnabled;
    @SerializedName(value="gemini.model")
    private String model;
    @SerializedName(value="gemini.model.transcribe")
    String transcribeModel;

    @Property(order=1, password=true)
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Integer getContextWindowSize() {
        return null;
    }

    @Property(order=3)
    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @Property(order=2)
    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    @Property(order=4)
    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    public String getTranscribeModel() {
        return this.transcribeModel;
    }

    public void setTranscribeModel(String transcribeModel) {
        this.transcribeModel = transcribeModel;
    }

    public void resolveSecrets() throws DBException {
        this.token = AIUtils.getSecretValueOrDefault((String)GEMINI_TOKEN, (String)this.token);
    }

    public void saveSecrets() throws DBException {
        if (this.token != null) {
            DBSSecretController.getGlobalSecretController().setPrivateSecretValue(GEMINI_TOKEN, this.token);
        }
    }

    public boolean isValidConfiguration() {
        return !CommonUtils.isEmpty((String)this.getToken());
    }
}

