/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.engine.gemini;

import com.dbeaver.model.ai.audio.AIAudioStream;
import com.dbeaver.model.ai.audio.AIEngineAudio;
import com.dbeaver.model.ai.audio.AITranscriptResult;
import com.dbeaver.model.ai.engine.gemini.GeminiAITranscriber;
import com.dbeaver.model.ai.engine.gemini.GeminiClient;
import com.dbeaver.model.ai.engine.gemini.GeminiProperties;
import com.dbeaver.model.ai.engine.gemini.dto.GeminiCandidate;
import com.dbeaver.model.ai.engine.gemini.dto.GeminiContent;
import com.dbeaver.model.ai.engine.gemini.dto.GeminiGenerateRequest;
import com.dbeaver.model.ai.engine.gemini.dto.GeminiGenerationConfig;
import com.dbeaver.model.ai.engine.gemini.dto.GeminiModel;
import com.dbeaver.model.ai.engine.gemini.dto.GeminiSystemInstruction;
import com.dbeaver.model.ai.engine.gemini.dto.GeminiTextPart;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.engine.AIEngineRequest;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponse;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseConsumer;
import org.jkiss.dbeaver.model.ai.engine.AIFunctionCall;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.AIModelFeature;
import org.jkiss.dbeaver.model.ai.engine.BaseCompletionEngine;
import org.jkiss.dbeaver.model.ai.utils.DisposableLazyValue;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class GeminiCompletionEngine
extends BaseCompletionEngine<GeminiProperties>
implements AIEngineAudio {
    private static final Log log = Log.getLog(GeminiCompletionEngine.class);
    private final DisposableLazyValue<GeminiClient, DBException> client = new DisposableLazyValue<GeminiClient, DBException>(){

        protected void onDispose(@NotNull GeminiClient disposedValue) {
            disposedValue.close();
        }

        @NotNull
        protected GeminiClient initialize() {
            return new GeminiClient();
        }
    };

    public GeminiCompletionEngine(@NotNull GeminiProperties properties) {
        super((AIEngineProperties)properties);
    }

    @NotNull
    public GeminiModel getCurrentModelInfo(@NotNull DBRProgressMonitor monitor) throws DBException {
        String model = ((GeminiProperties)this.properties).getModel();
        return ((GeminiClient)((Object)this.client.getInstance())).getModelInformation(model, monitor, this.apiKey());
    }

    @NotNull
    public List<AIModel> getModels(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((GeminiClient)((Object)this.client.getInstance())).loadModels(monitor, this.apiKey()).stream().map(modelInfo -> new AIModel(modelInfo.name(), modelInfo.inputTokenLimit(), Set.of(AIModelFeature.CHAT))).toList();
    }

    @NotNull
    public AIEngineResponse requestCompletion(@NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request) throws DBException {
        List<AIMessage> systemMessages = request.getMessages().stream().takeWhile(it -> it.getRole() == AIMessageType.SYSTEM).toList();
        List<AIMessage> history = request.getMessages().stream().dropWhile(it -> it.getRole() == AIMessageType.SYSTEM).toList();
        GeminiGenerationConfig generationConfig = GeminiGenerationConfig.builder().temperature(0.5).topP(0.1).stopSequences(List.of("#", ";")).build();
        GeminiGenerateRequest.Builder requestBuilder = GeminiGenerateRequest.builder().contents(GeminiCompletionEngine.fromMessages(history)).systemInstruction(GeminiCompletionEngine.fromSystemInstructions(systemMessages)).generationConfig(generationConfig);
        if (CommonUtils.isEmpty((Collection)request.getFunctions())) {
            requestBuilder.functions(request.getFunctions());
        }
        GeminiGenerateRequest generateRequest = requestBuilder.build();
        String modelName = this.getCurrentModelInfo(monitor).name();
        List<GeminiCandidate.ContentPart> choices = ((GeminiClient)((Object)this.client.getInstance())).generateContent(monitor, this.apiKey(), generateRequest, modelName).candidates().stream().map(it -> it.content().parts().getFirst()).toList();
        if (choices.getFirst().functionCall() != null) {
            AIFunctionCall aiFunctionCall = new AIFunctionCall(choices.getFirst().functionCall().name(), choices.getFirst().functionCall().args());
            return new AIEngineResponse(aiFunctionCall);
        }
        return new AIEngineResponse(AIMessageType.ASSISTANT, Collections.singletonList(choices.stream().map(GeminiCandidate.ContentPart::text).findFirst().get()));
    }

    public void requestCompletionStream(@NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request, @NotNull AIEngineResponseConsumer listener) throws DBException {
        List<AIMessage> systemMessages = request.getMessages().stream().takeWhile(it -> it.getRole() == AIMessageType.SYSTEM).toList();
        List<AIMessage> history = request.getMessages().stream().dropWhile(it -> it.getRole() == AIMessageType.SYSTEM).toList();
        GeminiGenerationConfig generationConfig = GeminiGenerationConfig.builder().temperature(0.5).topP(0.1).stopSequences(List.of("#", ";")).build();
        GeminiGenerateRequest.Builder requestBuilder = GeminiGenerateRequest.builder().contents(GeminiCompletionEngine.fromMessages(history)).systemInstruction(GeminiCompletionEngine.fromSystemInstructions(systemMessages)).generationConfig(generationConfig);
        if (CommonUtils.isEmpty((Collection)request.getFunctions())) {
            requestBuilder.functions(request.getFunctions());
        }
        GeminiGenerateRequest generateRequest = requestBuilder.build();
        ((GeminiClient)((Object)this.client.getInstance())).generateStreamContent(monitor, this.apiKey(), generateRequest, this.getCurrentModelInfo(monitor).name(), listener);
    }

    public int getContextWindowSize(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getCurrentModelInfo(monitor).inputTokenLimit();
    }

    public void close() throws DBException {
        this.client.dispose();
    }

    private static String mapRole(AIMessageType role) {
        return switch (role) {
            case AIMessageType.ASSISTANT -> "model";
            case AIMessageType.SYSTEM -> "system";
            case AIMessageType.USER -> "user";
            default -> null;
        };
    }

    private static List<GeminiContent> fromMessages(List<AIMessage> messages) {
        return messages.stream().map(daiChatMessage -> new GeminiContent(GeminiCompletionEngine.mapRole(daiChatMessage.getRole()), List.of(new GeminiTextPart(daiChatMessage.getContent())))).collect(Collectors.toList());
    }

    @Nullable
    private static GeminiSystemInstruction fromSystemInstructions(@NotNull List<AIMessage> systemInstructions) {
        if (systemInstructions.isEmpty()) {
            return null;
        }
        return new GeminiSystemInstruction(systemInstructions.stream().map(daiChatMessage -> new GeminiTextPart(daiChatMessage.getContent())).collect(Collectors.toList()));
    }

    @Override
    @NotNull
    public AITranscriptResult createSpeechTranscription(@NotNull AIAudioStream audio) throws DBException {
        try {
            return this.createTranscriber().transcribe(audio).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DBException("Transcription was interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new DBException("Error transcribing audio: " + e.getMessage(), (Throwable)e);
        }
    }

    private String apiKey() {
        return URLEncoder.encode(((GeminiProperties)this.properties).getToken(), StandardCharsets.UTF_8);
    }

    @NotNull
    protected GeminiAITranscriber<GeminiProperties> createTranscriber() throws DBException {
        return new GeminiAITranscriber<GeminiProperties>(this.getClient(), (GeminiProperties)this.properties);
    }

    @NotNull
    public GeminiClient getClient() throws DBException {
        return (GeminiClient)((Object)this.client.getInstance());
    }
}

