/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.engine.azure;

import com.dbeaver.model.ai.engine.azure.AzureAIEngine;
import com.dbeaver.model.ai.engine.azure.AzureAIServiceType;
import com.dbeaver.model.ai.engine.openai.OpenAIBaseProProperties;
import com.google.gson.annotations.SerializedName;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.engine.AIEngineRequest;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIModels;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIResponsesResponse;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.utils.CommonUtils;

public class AzureAIProperties
implements OpenAIBaseProProperties {
    public static final String AZURE_TOKEN = "azure.token";
    private static final int DEFAULT_CONTEXT_WINDOW_SIZE = 16384;
    private static final String GPT_TOKEN = "gpt.token";
    private static final String AZURE_ENDPOINT_URL = "azure.endpoint.url";
    private static final String AZURE_SERVICE_TYPE = "azure.service.type";
    private static final String AZURE_CONTEXT_WINDOW_SIZE = "azure.contextWindowSize";
    private static final String AZURE_DEPLOYMENT = "azure.deployment";
    private static final String AZURE_AUDIO_DEPLOYMENT = "azure.audio.deployment";
    private static final String GPT_MODEL_TEMPERATURE = "gpt.model.temperature";
    private static final String GPT_LOG_QUERY = "gpt.log.query";
    @SecureProperty
    @SerializedName(value="gpt.token")
    private String token;
    @SerializedName(value="azure.endpoint.url")
    private String url;
    @SerializedName(value="azure.service.type")
    private AzureAIServiceType serviceType = AzureAIServiceType.OPENAI;
    @SerializedName(value="azure.contextWindowSize")
    private Integer contextWindowSize;
    @SerializedName(value="azure.deployment")
    private String deployment;
    @SerializedName(value="azure.audio.deployment")
    private String audioDeployment;
    @SerializedName(value="gpt.model.temperature")
    private double temperature;
    @SerializedName(value="gpt.log.query")
    private boolean loggingEnabled;
    private volatile transient Integer modelContextSize;

    @Property(order=1, password=true)
    public String getToken() {
        return this.token;
    }

    public boolean isLegacyApi() {
        return false;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @Property(order=2)
    @Nullable
    public String getBaseUrl() {
        return this.url;
    }

    @Property(order=3)
    @Nullable
    public String getDeployment() {
        return this.deployment;
    }

    public void setDeployment(String deployment) {
        this.deployment = deployment;
        this.modelContextSize = null;
    }

    @Property(order=4)
    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @Property(order=5)
    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    @Property(order=6)
    public Integer getContextWindowSize() {
        return this.contextWindowSize;
    }

    public void setContextWindowSize(Integer contextWindowSize) {
        this.contextWindowSize = contextWindowSize;
    }

    @Nullable
    public String getModel() {
        return null;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    public void setBaseUrl(String url) {
        this.url = url;
    }

    public AzureAIServiceType getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(AzureAIServiceType serviceType) {
        this.serviceType = serviceType;
    }

    @Nullable
    public String getAudioDeployment() {
        return this.audioDeployment;
    }

    public void setAudioDeployment(String audioDeployment) {
        this.audioDeployment = audioDeployment;
    }

    public void resolveSecrets() throws DBException {
        this.token = AIUtils.getSecretValueOrDefault((String)AZURE_TOKEN, (String)this.token);
    }

    public void saveSecrets() throws DBException {
        if (this.token != null) {
            DBSSecretController.getGlobalSecretController().setPrivateSecretValue(AZURE_TOKEN, this.token);
        }
    }

    public boolean isValidConfiguration() {
        return !CommonUtils.isEmpty((String)this.getUrl()) && !CommonUtils.isEmpty((String)this.getDeployment()) && !CommonUtils.isEmpty((String)this.getToken());
    }

    @Override
    @NotNull
    public String getTranscribeModel() {
        return "whisper-1";
    }

    public int getContextWindowSize(@NotNull DBRProgressMonitor monitor, @NotNull AzureAIEngine engine) throws DBException {
        if (this.contextWindowSize != null) {
            return this.contextWindowSize;
        }
        if (this.modelContextSize != null) {
            return this.modelContextSize;
        }
        this.modelContextSize = this.computeMaxTokens(monitor, engine);
        return this.modelContextSize;
    }

    private int computeMaxTokens(@NotNull DBRProgressMonitor monitor, @NotNull AzureAIEngine engine) throws DBException {
        Integer windowSize;
        Integer contextWindowFromProperties = this.getContextWindowSize();
        if (contextWindowFromProperties != null) {
            return contextWindowFromProperties;
        }
        OAIResponsesResponse result = engine.singleMessage(monitor, new AIEngineRequest(AIMessage.userMessage((String)"ping")));
        AIModel knownModel = (AIModel)OpenAIModels.KNOWN_MODELS.get(result.model);
        if (knownModel != null && (windowSize = knownModel.contextWindowSize()) != null) {
            return windowSize;
        }
        return 16384;
    }
}

