/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.engine.azure;

import com.dbeaver.model.ai.audio.AIEngineAudio;
import com.dbeaver.model.ai.engine.azure.AzureAIClient;
import com.dbeaver.model.ai.engine.azure.AzureAIProperties;
import com.dbeaver.model.ai.engine.azure.AzureAIServiceType;
import com.dbeaver.model.ai.engine.azure.AzureRequestFilter;
import com.dbeaver.model.ai.engine.openai.OpenAIBaseProProperties;
import com.dbeaver.model.ai.engine.openai.OpenAIEnginePro;
import com.dbeaver.model.ai.engine.openai.OpenAITranscriber;
import java.net.URI;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.engine.AIEngineRequest;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIResponsesResponse;
import org.jkiss.dbeaver.model.ai.utils.AIHttpUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class AzureAIEngine
extends OpenAIEnginePro<AzureAIProperties>
implements AIEngineAudio {
    private static final Log log = Log.getLog(AzureAIEngine.class);
    public static final String ENDPOINT_AUDIO_TRANSCRIPTIONS = "audio/transcriptions";
    private static final String API_VERSION = "2025-04-01-preview";

    public AzureAIEngine(@NotNull AzureAIProperties properties) {
        super(properties);
    }

    @NotNull
    public List<AIModel> getModels(@NotNull DBRProgressMonitor monitor) {
        return List.of();
    }

    public OAIResponsesResponse singleMessage(@NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request) throws DBException {
        return super.complete(monitor, request);
    }

    protected String model() {
        return ((AzureAIProperties)this.properties).getDeployment();
    }

    protected double temperature() throws DBException {
        return ((AzureAIProperties)this.properties).getTemperature();
    }

    @Override
    @NotNull
    protected AzureAIClient createClient() throws DBException {
        URI serviceURI = ((AzureAIProperties)this.properties).getServiceType() == AzureAIServiceType.FOUNDRY ? this.createFoundryEndpoint() : this.createDeploymentEndpoint();
        return new AzureAIClient(serviceURI.toString(), List.of(new AzureRequestFilter(((AzureAIProperties)this.properties).getToken(), API_VERSION)));
    }

    @NotNull
    private URI createFoundryEndpoint() throws DBException {
        return AIHttpUtils.resolve((String)((AzureAIProperties)this.properties).getUrl(), (String[])new String[0]);
    }

    @NotNull
    private URI createDeploymentEndpoint() throws DBException {
        String url = ((AzureAIProperties)this.properties).getUrl();
        if (CommonUtils.isEmpty((String)url)) {
            throw new DBException("Azure OpenAI URL is not specified in properties");
        }
        return AIHttpUtils.resolve((String)url, (String[])new String[0]);
    }

    public int getContextWindowSize(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((AzureAIProperties)this.properties).getContextWindowSize(monitor, this);
    }

    @NotNull
    private URI createAudioDeploymentEndpoint() throws DBException {
        String audioDeployment = ((AzureAIProperties)this.properties).getAudioDeployment();
        if (CommonUtils.isEmpty((String)audioDeployment)) {
            return this.createDeploymentEndpoint();
        }
        return AIHttpUtils.resolve((String)((AzureAIProperties)this.properties).getUrl(), (String[])new String[0]).resolve("/openai/deployments/" + audioDeployment + "/");
    }

    @Override
    @NotNull
    protected OpenAITranscriber<OpenAIBaseProProperties> createTranscriber() throws DBException {
        URI serviceURI = ((AzureAIProperties)this.properties).getServiceType() == AzureAIServiceType.FOUNDRY ? this.createFoundryEndpoint().resolve(ENDPOINT_AUDIO_TRANSCRIPTIONS) : this.createAudioDeploymentEndpoint().resolve(ENDPOINT_AUDIO_TRANSCRIPTIONS);
        return new OpenAITranscriber<OpenAIBaseProProperties>(this.createClient(), (OpenAIBaseProProperties)this.properties, serviceURI);
    }
}

