/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.engine.anthropic;

import com.dbeaver.model.ai.engine.anthropic.AnthropicModels;
import com.google.gson.annotations.SerializedName;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.AIModelFeature;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class AnthropicProperties
implements AIEngineProperties {
    private static final String ANTHROPIC_TOKEN = "anthropic.token";
    private static final String ANTHROPIC_LOG_QUERY = "anthropic.log.query";
    private static final String ANTHROPIC_MODEL = "anthropic.model";
    private static final String ANTHROPIC_TEMPERATURE = "anthropic.temperature";
    private static final String ANTHROPIC_CONTEXT_WINDOW_SIZE = "anthropic.contextWindowSize";
    @SecureProperty
    @SerializedName(value="anthropic.token")
    private String token;
    @SerializedName(value="anthropic.log.query")
    private boolean loggingEnabled;
    @SerializedName(value="anthropic.model")
    private String model;
    @SerializedName(value="anthropic.temperature")
    private double temperature;
    @SerializedName(value="anthropic.contextWindowSize")
    private Integer contextWindowSize;

    @Property(order=1, password=true)
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @Property(order=2, listProvider=AnthropicModelListProvider.class)
    @NotNull
    public String getModel() {
        if (this.model != null) {
            return AnthropicModels.getEffectiveModelName(this.model);
        }
        String modelName = DBWorkbench.getPlatform().getPreferenceStore().getString("anthropic_model");
        return AnthropicModels.getEffectiveModelName(modelName);
    }

    public void setModel(String model) {
        this.model = model;
    }

    public boolean isValidConfiguration() {
        return !CommonUtils.isEmpty((String)this.getToken());
    }

    @Property(order=3)
    public double getTemperature() {
        if (this.temperature != 0.0) {
            return this.temperature;
        }
        return AnthropicModels.getModelByName(this.getModel()).map(AIModel::defaultTemperature).orElse(0.0);
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @Property(order=4)
    @Nullable
    public Integer getContextWindowSize() {
        if (this.contextWindowSize != null) {
            return this.contextWindowSize;
        }
        return AnthropicModels.getModelByName(this.model).map(AIModel::contextWindowSize).orElse(null);
    }

    public void setContextWindowSize(Integer contextWindowSize) {
        this.contextWindowSize = contextWindowSize;
    }

    public int getContextSize() {
        if (this.contextWindowSize != null) {
            return this.contextWindowSize;
        }
        return AnthropicModels.KNOWN_MODELS.getOrDefault(this.getModel(), AnthropicModels.KNOWN_MODELS.get("claude-opus-4-1-20250805")).contextWindowSize();
    }

    @Property(order=5)
    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    public void resolveSecrets() throws DBException {
        this.token = AIUtils.getSecretValueOrDefault((String)ANTHROPIC_TOKEN, (String)this.token);
    }

    public void saveSecrets() throws DBException {
        if (this.token != null) {
            DBSSecretController.getGlobalSecretController().setPrivateSecretValue(ANTHROPIC_TOKEN, this.token);
        }
    }

    public static class AnthropicModelListProvider
    implements IPropertyValueListProvider<AnthropicProperties> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(AnthropicProperties object) {
            return AnthropicModels.KNOWN_MODELS.entrySet().stream().filter(entry -> !((AIModel)entry.getValue()).features().contains(AIModelFeature.SPEECH_TO_TEXT)).map(Map.Entry::getKey).toArray();
        }
    }
}

