/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.engine.anthropic;

import com.dbeaver.model.ai.engine.anthropic.AnthropicClient;
import com.dbeaver.model.ai.engine.anthropic.AnthropicModels;
import com.dbeaver.model.ai.engine.anthropic.AnthropicProperties;
import com.dbeaver.model.ai.engine.anthropic.dto.AnthropicChatCompletionRequest;
import com.dbeaver.model.ai.engine.anthropic.dto.AnthropicChatCompletionResult;
import com.dbeaver.model.ai.engine.anthropic.dto.AnthropicChatMessage;
import com.dbeaver.model.ai.engine.anthropic.dto.AnthropicTool;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.engine.AIEngineRequest;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponse;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseConsumer;
import org.jkiss.dbeaver.model.ai.engine.AIFunctionCall;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.BaseCompletionEngine;
import org.jkiss.dbeaver.model.ai.registry.AIFunctionDescriptor;
import org.jkiss.dbeaver.model.ai.utils.DisposableLazyValue;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class AnthropicCompletionEngine
extends BaseCompletionEngine<AnthropicProperties> {
    private final DisposableLazyValue<AnthropicClient, DBException> client = new DisposableLazyValue<AnthropicClient, DBException>(){

        protected void onDispose(@NotNull AnthropicClient disposedValue) {
            disposedValue.close();
        }

        @NotNull
        protected AnthropicClient initialize() {
            return new AnthropicClient(((AnthropicProperties)AnthropicCompletionEngine.this.properties).getToken());
        }
    };

    public AnthropicCompletionEngine(@NotNull AnthropicProperties properties) {
        super((AIEngineProperties)properties);
    }

    @NotNull
    public List<AIModel> getModels(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((AnthropicClient)((Object)this.client.getInstance())).loadModels(monitor, this.apiKey()).stream().map(model -> AnthropicModels.KNOWN_MODELS.getOrDefault(model.id(), new AIModel(model.id(), null, AnthropicModels.detectModelFeatures(model.id())))).toList();
    }

    @NotNull
    public AIEngineResponse requestCompletion(@NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request) throws DBException {
        AnthropicChatCompletionResult completionResult = this.complete(monitor, request.getMessages(), request.getFunctions());
        Optional<AnthropicChatCompletionResult.Content> functionCallContent = completionResult.content().stream().filter(it -> it.type().equals("tool_use")).findFirst();
        if (functionCallContent.isPresent()) {
            AIFunctionCall functionCall = new AIFunctionCall(functionCallContent.get().name(), functionCallContent.get().input());
            return new AIEngineResponse(functionCall);
        }
        List<String> choices = completionResult.content().stream().filter(it -> it.type().equals("text")).map(AnthropicChatCompletionResult.Content::text).toList();
        return new AIEngineResponse(AIMessageType.ASSISTANT, choices);
    }

    public void requestCompletionStream(@NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request, @NotNull AIEngineResponseConsumer listener) throws DBException {
        AnthropicChatCompletionRequest completionRequest = this.createCompletionRequest(request.getMessages(), request.getFunctions());
        completionRequest.setStream(true);
        ((AnthropicClient)((Object)this.client.getInstance())).createChatCompletionStream(monitor, completionRequest, listener);
    }

    public int getContextWindowSize(@NotNull DBRProgressMonitor monitor) {
        return ((AnthropicProperties)this.properties).getContextSize();
    }

    public void close() throws DBException {
        this.client.dispose();
    }

    private AnthropicChatCompletionResult complete(@NotNull DBRProgressMonitor monitor, @NotNull List<AIMessage> messages, List<AIFunctionDescriptor> functions) throws DBException {
        AnthropicChatCompletionRequest completionRequest = this.createCompletionRequest(messages, functions);
        return ((AnthropicClient)((Object)this.client.getInstance())).createChatCompletion(monitor, completionRequest);
    }

    @NotNull
    private AnthropicChatCompletionRequest createCompletionRequest(@NotNull List<AIMessage> messages, List<AIFunctionDescriptor> functions) {
        AnthropicChatCompletionRequest completionRequest = new AnthropicChatCompletionRequest();
        completionRequest.setMessages(AnthropicCompletionEngine.fromMessages(messages));
        completionRequest.setModel(this.model());
        AnthropicCompletionEngine.addSystemMessage(messages, completionRequest);
        this.addAvailableFunctions(completionRequest, functions);
        return completionRequest;
    }

    private void addAvailableFunctions(@NotNull AnthropicChatCompletionRequest request, @NotNull List<AIFunctionDescriptor> functions) {
        for (AIFunctionDescriptor function : functions) {
            AnthropicTool tool = new AnthropicTool(function);
            request.addTool(tool);
        }
    }

    private static void addSystemMessage(@NotNull List<AIMessage> messages, @NotNull AnthropicChatCompletionRequest completionRequest) {
        AIMessage aiMessage = messages.stream().filter(m -> m.getRole() == AIMessageType.SYSTEM).findFirst().orElse(null);
        if (aiMessage != null) {
            completionRequest.setSystem(aiMessage.getContent());
        }
    }

    private String model() {
        return ((AnthropicProperties)this.properties).getModel();
    }

    private Double temperature() {
        return ((AnthropicProperties)this.properties).getTemperature();
    }

    @NotNull
    private static List<AnthropicChatMessage> fromMessages(@NotNull List<AIMessage> messages) {
        List<AnthropicChatMessage> list = messages.stream().filter(m -> m.getRole() == AIMessageType.USER || m.getRole() == AIMessageType.ASSISTANT).map(m -> new AnthropicChatMessage(AnthropicCompletionEngine.mapRole(m.getRole()), m.getContent())).toList();
        if (list.isEmpty()) {
            return List.of(new AnthropicChatMessage("user", "Respond based on system instructions."));
        }
        return list;
    }

    private static String mapRole(AIMessageType role) {
        return switch (role) {
            case AIMessageType.USER -> "user";
            case AIMessageType.ASSISTANT -> "assistant";
            case AIMessageType.SYSTEM -> "system";
            default -> null;
        };
    }

    private String apiKey() throws DBException {
        return URLEncoder.encode(((AnthropicProperties)this.properties).getToken(), StandardCharsets.UTF_8);
    }
}

