/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.audio.processing;

import com.dbeaver.model.ai.audio.AIAudioRecorder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.SubmissionPublisher;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.sound.sampled.AudioFormat;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class SilenceFilter
extends SubmissionPublisher<ByteBuffer>
implements Flow.Processor<ByteBuffer, ByteBuffer> {
    private static final Log log = Log.getLog(SilenceFilter.class);
    private final int minSilentFrames;
    private final int trailingFrames;
    private final AudioFormat format;
    private final long maxSilenceInMillis;
    private final Runnable longSilenceAction;
    private final Queue<ByteBuffer> silenceBuffer = new ArrayDeque<ByteBuffer>();
    private Flow.Subscription upstream;
    private final AtomicReference<State> state = new AtomicReference<State>(State.SPEAKING);
    private int silenceFrames = 0;
    private final SilenceDetector detector;

    public SilenceFilter(float minSilentMillis, float trailingMillis, @NotNull AudioFormat format, long maxSilenceInMillis, @NotNull Runnable longSilenceAction, @NotNull Executor executor) {
        super(executor, 4096);
        float frameRate = Math.max(1.0f, format.getFrameRate());
        this.minSilentFrames = Math.max(1, (int)Math.ceil(minSilentMillis / 1000.0f * frameRate));
        this.trailingFrames = Math.max(1, (int)Math.ceil(trailingMillis / 1000.0f * frameRate));
        this.format = format;
        this.maxSilenceInMillis = maxSilenceInMillis;
        this.longSilenceAction = longSilenceAction;
        this.detector = this.buildDetector(format);
    }

    @NotNull
    private SilenceDetector buildDetector(@NotNull AudioFormat format) {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        double percent = store.contains("ai.transcript.silence.threshold") ? store.getDouble("ai.transcript.silence.threshold") : 0.3;
        return new FixedSilenceDetector(SilenceDetector.percentToPcm16Amplitude(percent), format.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void onSubscribe(@NotNull Flow.Subscription subscription) {
        this.upstream = subscription;
        subscription.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(@NotNull ByteBuffer item) {
        if (item == AIAudioRecorder.RESET_SIGNAL) {
            this.submitWithSilence(item);
            this.upstream.request(Long.MAX_VALUE);
            return;
        }
        if (this.detector.isSilent(item)) {
            long silenceMillis;
            this.silenceBuffer.add(item);
            this.silenceFrames += this.framesIn(item);
            if (this.silenceFrames >= this.minSilentFrames) {
                this.state.compareAndSet(State.SPEAKING, State.SILENT);
            }
            if ((silenceMillis = Math.round((double)((float)this.silenceFrames / this.format.getFrameRate()) * 1000.0)) > this.maxSilenceInMillis) {
                this.silenceBuffer.clear();
                this.silenceFrames = 0;
                this.longSilenceAction.run();
            }
        } else {
            this.submitWithSilence(item);
        }
        this.upstream.request(Long.MAX_VALUE);
    }

    /*
     * Unable to fully structure code
     */
    private void submitWithSilence(@NotNull ByteBuffer item) {
        block6: {
            if (this.state.get() != State.SILENT) ** GOTO lbl20
            this.state.set(State.SPEAKING);
            skipFrames = Math.max(0, this.silenceFrames - this.trailingFrames);
            for (ByteBuffer buf : this.silenceBuffer) {
                f = this.framesIn(buf);
                if (skipFrames >= f) {
                    skipFrames -= f;
                    continue;
                }
                if (skipFrames > 0) {
                    tail = buf.slice();
                    tail.position(tail.position() + skipFrames * this.format.getFrameSize());
                    this.offerNonBlocking(tail.slice());
                    skipFrames = 0;
                    continue;
                }
                this.offerNonBlocking(buf.slice());
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                this.offerNonBlocking(this.silenceBuffer.poll().slice());
lbl20:
                // 2 sources

                ** while (!this.silenceBuffer.isEmpty())
            }
        }
        this.silenceBuffer.clear();
        this.silenceFrames = 0;
        if (item == AIAudioRecorder.RESET_SIGNAL) {
            this.submit(item);
        } else {
            this.offerNonBlocking(item);
        }
    }

    private void offerNonBlocking(@NotNull ByteBuffer buf) {
        boolean ok;
        ByteBuffer toSend = buf.isReadOnly() ? buf : buf.asReadOnlyBuffer();
        boolean bl = ok = this.offer(toSend, 100L, TimeUnit.MILLISECONDS, (sub, el) -> false) >= 0;
        if (!ok) {
            log.warn((Object)("Dropping frame for subscriber: " + String.valueOf(this.upstream)));
        }
    }

    private int framesIn(@NotNull ByteBuffer b) {
        return b.remaining() / this.format.getFrameSize();
    }

    @Override
    public void onError(@NotNull Throwable throwable) {
        this.closeExceptionally(throwable);
    }

    @Override
    public void onComplete() {
    }

    public record FixedSilenceDetector(int minSampleThreshold, ByteOrder order) implements SilenceDetector
    {
        @Override
        public boolean isSilent(@NotNull ByteBuffer frame) {
            int maxAmplitude = SilenceDetector.maxAbsPcm16(frame, this.order);
            return maxAmplitude < this.minSampleThreshold;
        }
    }

    public static interface SilenceDetector {
        public boolean isSilent(@NotNull ByteBuffer var1);

        private static int maxAbsPcm16(@NotNull ByteBuffer frame, @NotNull ByteOrder order) {
            ByteBuffer buf = frame.duplicate().order(order);
            int max = 0;
            int i = 0;
            while (i + 1 < buf.limit()) {
                short s = buf.getShort(i);
                int a = Math.abs(s);
                if (a > max) {
                    max = a;
                }
                i += 2;
            }
            return max;
        }

        public static int dbfsToPcm16Amplitude(double dbfs) {
            double ratio = Math.pow(10.0, dbfs / 20.0);
            return (int)Math.max(1L, Math.round(32767.0 * ratio));
        }

        public static int percentToPcm16Amplitude(double percent) {
            if (percent <= 0.0) {
                return 1;
            }
            if (percent > 100.0) {
                percent = 100.0;
            }
            double ratio = percent / 100.0;
            return (int)Math.max(1L, Math.round(32767.0 * ratio));
        }
    }

    private static enum State {
        SPEAKING,
        SILENT;

    }
}

