/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.audio.processing;

import com.dbeaver.model.ai.audio.AIAudioRecorder;
import com.dbeaver.model.ai.audio.AIAudioStream;
import com.dbeaver.model.ai.audio.processing.AudioSink;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.jkiss.code.NotNull;

public class InMemoryAudioSink
implements AudioSink {
    private final AudioFormat format;
    protected volatile CompletableFuture<AIAudioStream> capturedAudio;
    protected final GrowableBuffer buffer = new GrowableBuffer();
    private Flow.Subscription subscription;

    public InMemoryAudioSink(@NotNull AudioFormat format) {
        this.format = format;
    }

    @Override
    public void onSubscribe(@NotNull Flow.Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    @Override
    public void onNext(@NotNull ByteBuffer item) {
        if (item == AIAudioRecorder.RESET_SIGNAL) {
            this.persistBuffer();
        } else {
            this.buffer.write(item.duplicate());
        }
        this.subscription.request(1L);
    }

    @Override
    public void onError(@NotNull Throwable throwable) {
        this.capturedAudio.completeExceptionally(throwable);
    }

    @Override
    public void onComplete() {
        this.persistBuffer();
    }

    @Override
    @NotNull
    public CompletableFuture<AIAudioStream> beginNewCapture() {
        this.capturedAudio = new CompletableFuture();
        return this.capturedAudio;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void persistBuffer() {
        try {
            try {
                long frameCount = this.buffer.size() / this.format.getFrameSize();
                Throwable throwable = null;
                Object var4_5 = null;
                try {
                    InputStream input = this.buffer.asInputStream();
                    try {
                        block23: {
                            AudioInputStream pcmStream = new AudioInputStream(input, this.format, frameCount);
                            try {
                                try (ByteArrayOutputStream wavOut = new ByteArrayOutputStream(this.buffer.size() + 44);){
                                    AudioSystem.write(pcmStream, AudioFileFormat.Type.WAVE, wavOut);
                                    this.capturedAudio.complete(AIAudioStream.fromBytes(this.format, "audio/wav", wavOut.toByteArray()));
                                }
                                if (pcmStream == null) break block23;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (pcmStream == null) throw throwable;
                                pcmStream.close();
                                throw throwable;
                            }
                            pcmStream.close();
                        }
                        if (input == null) return;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (input == null) throw throwable;
                        input.close();
                        throw throwable;
                    }
                    input.close();
                    return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                        throw throwable;
                    }
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.capturedAudio.completeExceptionally(e);
                this.reset();
                return;
            }
        }
        finally {
            this.reset();
        }
    }

    @Override
    @NotNull
    public AudioFormat getFormat() {
        return this.format;
    }

    protected void reset() {
        this.buffer.reset();
    }

    public static final class GrowableBuffer
    extends OutputStream {
        private static final int DEFAULT_CAPACITY = 8192;
        private byte[] buffer;
        private int count;

        public GrowableBuffer() {
            this(8192);
        }

        public GrowableBuffer(int initialSize) {
            this.buffer = new byte[initialSize <= 0 ? 8192 : initialSize];
        }

        @Override
        public void write(int b) {
            this.ensureCapacity(this.count + 1);
            this.buffer[this.count++] = (byte)b;
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) {
            Objects.checkFromIndexSize(off, len, b.length);
            this.ensureCapacity(Math.addExact(this.count, len));
            System.arraycopy(b, off, this.buffer, this.count, len);
            this.count += len;
        }

        public void write(@NotNull ByteBuffer src) {
            int len = src.remaining();
            if (len <= 0) {
                return;
            }
            this.ensureCapacity(Math.addExact(this.count, len));
            if (src.hasArray() && !src.isReadOnly()) {
                int off = src.arrayOffset() + src.position();
                System.arraycopy(src.array(), off, this.buffer, this.count, len);
                src.position(src.position() + len);
            } else {
                src.get(this.buffer, this.count, len);
            }
            this.count += len;
        }

        public int size() {
            return this.count;
        }

        public void reset() {
            this.count = 0;
        }

        @NotNull
        public InputStream asInputStream() {
            return new ByteArrayInputStream(this.buffer, 0, this.count);
        }

        private void ensureCapacity(int minCapacity) {
            if (minCapacity > this.buffer.length) {
                int newCapacity = Math.max(this.buffer.length << 1, minCapacity);
                this.buffer = Arrays.copyOf(this.buffer, newCapacity);
            }
        }
    }
}

