/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.audio.processing;

import com.dbeaver.model.ai.audio.AIAudioStream;
import com.dbeaver.model.ai.audio.processing.InMemoryAudioSink;
import java.io.InputStream;
import java.nio.file.Path;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class FileAudioSink
extends InMemoryAudioSink {
    private static final Log log = Log.getLog(FileAudioSink.class);
    public static final String AUDIO_TEMP_FOLDER = "audio";
    public static final String AI_AUDIO_WAV = "ai_audio.wav";

    public FileAudioSink(@NotNull AudioFormat format) {
        super(format);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void persistBuffer() {
        AudioFormat format = this.getFormat();
        try {
            try {
                long frameCount = this.buffer.size() / format.getFrameSize();
                Throwable throwable = null;
                Object var5_6 = null;
                try {
                    InputStream input = this.buffer.asInputStream();
                    try {
                        try (AudioInputStream pcmStream = new AudioInputStream(input, format, frameCount);){
                            Path tempFolder = DBWorkbench.getPlatform().getTempFolder((DBRProgressMonitor)new VoidProgressMonitor(), AUDIO_TEMP_FOLDER);
                            Path path = tempFolder.resolve(AI_AUDIO_WAV);
                            AudioSystem.write(pcmStream, AudioFileFormat.Type.WAVE, path.toFile());
                            log.debug((Object)"Audio file %s is saved to %s".formatted(path.getFileName(), tempFolder.getFileName()));
                            this.capturedAudio.complete(AIAudioStream.fromFile(format, "audio/wav", path.toFile()));
                        }
                        if (input == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (input == null) throw throwable;
                        input.close();
                        throw throwable;
                    }
                    input.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.capturedAudio.completeExceptionally(e);
                this.reset();
            }
            return;
        }
        finally {
            this.reset();
        }
    }
}

