/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.audio;

import java.io.IOException;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.utils.CommonUtils;

public class AIAudioUtils {
    private static final Log log = Log.getLog(AIAudioUtils.class);

    @NotNull
    public static String detectAudioMime(@NotNull Path audioFile) {
        String mime = null;
        try {
            mime = Files.probeContentType(audioFile);
        }
        catch (IOException e) {
            log.debug((Object)"Cannot get file content type", (Throwable)e);
        }
        if (CommonUtils.isEmpty((String)mime) || "application/octet-stream".equalsIgnoreCase(mime)) {
            mime = URLConnection.guessContentTypeFromName(audioFile.getFileName().toString());
        }
        return CommonUtils.isEmpty((String)(mime = AIAudioUtils.normalizeMime(mime))) || "application/octet-stream".equalsIgnoreCase(mime) ? AIAudioUtils.guessByExtension(audioFile.getFileName().toString()) : mime;
    }

    @NotNull
    public static String guessByExtension(@NotNull String fileName) {
        String ext;
        return switch (ext = fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase(Locale.ROOT)) {
            case "wav" -> "audio/wav";
            case "mp3" -> "audio/mpeg";
            case "m4a" -> "audio/mp4";
            case "flac" -> "audio/flac";
            case "ogg" -> "audio/ogg";
            default -> "application/octet-stream";
        };
    }

    @Nullable
    private static String normalizeMime(@Nullable String mime) {
        if (mime == null) {
            return null;
        }
        return switch (mime.toLowerCase(Locale.ROOT)) {
            case "audio/x-wav", "audio/vnd.wave" -> "audio/wav";
            case "audio/x-flac" -> "audio/flac";
            case "audio/x-m4a" -> "audio/mp4";
            case "audio/x-ogg" -> "audio/ogg";
            default -> mime;
        };
    }
}

