/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.audio;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.jkiss.code.NotNull;

public interface AIAudioStream {
    public static final int WAV_HEADER_SIZE = 44;
    public static final double MIN_AUDIO_SECONDS = 1.0;

    @NotNull
    public String mimeType();

    @NotNull
    public String fileName();

    @NotNull
    public InputStream stream() throws IOException;

    @NotNull
    public byte[] data() throws IOException;

    public double lengthSeconds();

    @NotNull
    public static AIAudioStream fromBytes(@NotNull AudioFormat format, @NotNull String mimeType, @NotNull byte[] data) {
        return new InMemoryAIAudioStream(format, mimeType, data);
    }

    @NotNull
    public static AIAudioStream fromFile(@NotNull AudioFormat format, @NotNull String mimeType, @NotNull File file) {
        return new FileAIAudioStream(format, mimeType, file);
    }

    public record FileAIAudioStream(@NotNull AudioFormat format, @NotNull String mimeType, @NotNull File file) implements AIAudioStream
    {
        @Override
        @NotNull
        public String fileName() {
            return this.file.getName();
        }

        @Override
        @NotNull
        public InputStream stream() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.file));
        }

        @Override
        @NotNull
        public byte[] data() throws IOException {
            return Files.readAllBytes(this.file.toPath());
        }

        @Override
        public double lengthSeconds() {
            try {
                Throwable throwable = null;
                Object var2_5 = null;
                try (AudioInputStream ais = AudioSystem.getAudioInputStream(this.file);){
                    long frameLength = ais.getFrameLength();
                    float frameRate = ais.getFormat().getFrameRate();
                    if (frameLength != -1L && frameRate > 0.0f) {
                        return (double)frameLength / (double)frameRate;
                    }
                    long size = Files.size(this.file.toPath());
                    int frameSize = this.format.getFrameSize();
                    float rate = this.format.getFrameRate();
                    if (frameSize <= 0 || rate <= 0.0f) {
                        throw new IllegalArgumentException("Invalid audio format: frameSize=" + frameSize + ", frameRate=" + rate);
                    }
                    long dataBytes = Math.max(0L, size - 44L);
                    return (double)dataBytes / ((double)frameSize * (double)rate);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (UnsupportedAudioFileException e) {
                throw new IllegalArgumentException("Unsupported audio format", e);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read audio file", e);
            }
        }
    }

    public record InMemoryAIAudioStream(@NotNull AudioFormat format, @NotNull String mimeType, @NotNull byte[] data) implements AIAudioStream
    {
        @Override
        @NotNull
        public String fileName() {
            return "fake.wav";
        }

        @Override
        @NotNull
        public InputStream stream() {
            return new ByteArrayInputStream(this.data);
        }

        @Override
        public double lengthSeconds() {
            int frameSize = this.format.getFrameSize();
            float frameRate = this.format.getFrameRate();
            if (frameSize <= 0 || frameRate <= 0.0f) {
                throw new IllegalArgumentException("Invalid audio format: frameSize=" + frameSize + ", frameRate=" + frameRate);
            }
            return (double)this.data.length / ((double)frameSize * (double)frameRate);
        }
    }
}

