/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai;

import com.dbeaver.model.ai.AIChatConversation;
import com.dbeaver.model.ai.AIChatMessage;
import com.dbeaver.model.qm.ai.QMAIChatMessage;
import com.dbeaver.model.qm.ai.QMAIChatRole;
import com.dbeaver.model.qm.ai.QMAIContext;
import com.dbeaver.model.qm.ai.QMAIContextObject;
import com.dbeaver.model.qm.ai.QMAIContextObjectType;
import com.dbeaver.model.qm.ai.QMAIConversationHistory;
import com.dbeaver.model.qm.ai.QMAIDataSource;
import java.lang.runtime.SwitchBootstraps;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.ai.AIContextSettings;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.dbeaver.model.ai.AIPromptGenerator;
import org.jkiss.dbeaver.model.ai.engine.AIDatabaseContext;
import org.jkiss.dbeaver.model.ai.prompt.AIPromptGenerateSql;
import org.jkiss.dbeaver.model.ai.registry.AIPromptGeneratorDescriptor;
import org.jkiss.dbeaver.model.ai.registry.AIPromptGeneratorRegistry;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSourceSupplier;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.CommonUtils;

public class QMAIChatHistoryMapper {
    private static final Log log = Log.getLog(QMAIChatHistoryMapper.class);

    @NotNull
    public static QMAIConversationHistory toQMAIChatHistory(@NotNull AIChatConversation conversation, @Nullable AIContextSettings contextSettings, @Nullable AIDatabaseContext context) {
        List<QMAIChatMessage> chatMessages = QMAIChatHistoryMapper.toQMAIChatMessages(conversation.getMessages());
        DBPDataSourceContainer chatDataSource = conversation.getDataSource();
        QMAIDataSource dataSource = chatDataSource == null ? null : new QMAIDataSource(chatDataSource.getProject().getId(), chatDataSource.getId());
        String contextJson = contextSettings == null ? null : contextSettings.saveSettingsToString();
        QMAIContext qmaiContext = new QMAIContext(contextJson, context == null ? Set.of() : QMAIChatHistoryMapper.toQMAIContextObjects(context));
        return new QMAIConversationHistory(conversation.getId().toString(), conversation.getCaption(), conversation.getPromptGenerator().generatorId(), dataSource, chatMessages, qmaiContext, conversation.getNextMessageId(), false);
    }

    @NotNull
    public static AIChatConversation toAIChatConversation(@NotNull QMAIConversationHistory history, @Nullable DBPDataSourceContainer container) {
        AIPromptGeneratorDescriptor generatorDescriptor;
        DBSLogicalDataSourceSupplier dsSupplier = () -> container == null ? null : new DBSLogicalDataSource(container);
        AIPromptGenerateSql generator = null;
        String promptGeneratorId = history.getPromptGeneratorId();
        if (promptGeneratorId != null && (generatorDescriptor = AIPromptGeneratorRegistry.getInstance().getPromptGenerator(promptGeneratorId)) != null) {
            try {
                generator = generatorDescriptor.createGenerator(dsSupplier);
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        if (generator == null) {
            log.trace((Object)("AI prompt generator '" + promptGeneratorId + "' not found. Use default"));
            generator = AIPromptGenerateSql.create((DBSLogicalDataSourceSupplier)dsSupplier);
        }
        return new AIChatConversation(UUID.fromString(history.getId()), history.getCaption(), (AIPromptGenerator)generator, QMAIChatHistoryMapper.toAIMessages(history.getMessages()), container, history.getNextMessageId());
    }

    @NotNull
    public static List<QMAIChatMessage> toQMAIChatMessages(@NotNull List<AIChatMessage> messages) {
        Predicate<AIMessage> isMessageToStore = it -> it.getRole() == AIMessageType.USER || it.getRole() == AIMessageType.ASSISTANT;
        return messages.stream().filter(it -> isMessageToStore.test(it.message())).map(it -> new QMAIChatMessage(it.id(), it.message().getContent(), it.message().getRawDisplayMessage(), (QMAIChatRole)CommonUtils.valueOf(QMAIChatRole.class, (String)it.message().getRole().name(), (Enum)QMAIChatRole.USER), it.message().getTime().toInstant(ZoneOffset.UTC), false)).toList();
    }

    @NotNull
    public static List<AIChatMessage> toAIMessages(@NotNull List<QMAIChatMessage> messages) {
        return messages.stream().map(it -> {
            AIMessage aiMessage = new AIMessage(AIMessageType.valueOf((String)it.role().name()), it.content(), it.displayMessage(), LocalDateTime.ofInstant(it.timestamp(), ZoneId.systemDefault()));
            return new AIChatMessage(it.id(), aiMessage);
        }).toList();
    }

    public static Set<QMAIContextObject> toQMAIContextObjects(@NotNull AIDatabaseContext context) {
        switch (context.getScope()) {
            case CURRENT_DATASOURCE: {
                return Set.of(new QMAIContextObject(context.getDataSource().getName(), QMAIContextObjectType.DATASOURCE));
            }
            case CURRENT_DATABASE: {
                return Set.of(new QMAIContextObject(context.getScopeObject().getName(), QMAIContextObjectType.DATABASE));
            }
            case CURRENT_SCHEMA: {
                return Set.of(new QMAIContextObject(context.getScopeObject().getName(), QMAIContextObjectType.SCHEMA));
            }
            case CUSTOM: {
                return context.getCustomEntities() == null ? Set.of() : context.getCustomEntities().stream().filter(Objects::nonNull).map(entity -> new QMAIContextObject(entity.getName(), QMAIChatHistoryMapper.defineObjectType(entity))).collect(Collectors.toSet());
            }
        }
        throw new IllegalArgumentException("Unsupported scope: " + String.valueOf(context.getScope()));
    }

    @NotNull
    public static QMAIContextObjectType defineObjectType(@NotNull DBSObject object) {
        DBSObject dBSObject = object;
        Objects.requireNonNull(dBSObject);
        DBSObject dBSObject2 = dBSObject;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DBSLogicalDataSource.class, DBSObjectContainer.class, DBPDataSource.class}, (Object)dBSObject2, 0)) {
            case 0 -> {
                DBSLogicalDataSource ignored = (DBSLogicalDataSource)dBSObject2;
                yield QMAIContextObjectType.DATASOURCE;
            }
            case 1 -> {
                DBSObjectContainer ignored = (DBSObjectContainer)dBSObject2;
                yield QMAIContextObjectType.SCHEMA;
            }
            case 2 -> {
                DBPDataSource ignored = (DBPDataSource)dBSObject2;
                yield QMAIContextObjectType.DATABASE;
            }
            default -> QMAIContextObjectType.TABLE;
        };
    }
}

